// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Azure FirstParty Managed Certificate provided by other first party resource providers to enable HTTPS.
 */
@Fluent
public final class AzureFirstPartyManagedCertificateParameters extends SecretParameters {
    /*
     * The type of the secret resource.
     */
    private SecretType type = SecretType.AZURE_FIRST_PARTY_MANAGED_CERTIFICATE;

    /*
     * Resource reference to the Azure Key Vault certificate. Expected to be in format of
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}/secrets/{certificateName}
     */
    private ResourceReference secretSource;

    /*
     * Subject name in the certificate.
     */
    private String subject;

    /*
     * Certificate expiration date.
     */
    private String expirationDate;

    /*
     * Certificate issuing authority.
     */
    private String certificateAuthority;

    /*
     * The list of SANs.
     */
    private List<String> subjectAlternativeNames;

    /*
     * Certificate thumbprint.
     */
    private String thumbprint;

    /**
     * Creates an instance of AzureFirstPartyManagedCertificateParameters class.
     */
    public AzureFirstPartyManagedCertificateParameters() {
    }

    /**
     * Get the type property: The type of the secret resource.
     *
     * @return the type value.
     */
    @Override
    public SecretType type() {
        return this.type;
    }

    /**
     * Get the secretSource property: Resource reference to the Azure Key Vault certificate. Expected to be in format of
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}/secrets/{certificateName}.
     *
     * @return the secretSource value.
     */
    public ResourceReference secretSource() {
        return this.secretSource;
    }

    /**
     * Get the subject property: Subject name in the certificate.
     *
     * @return the subject value.
     */
    public String subject() {
        return this.subject;
    }

    /**
     * Get the expirationDate property: Certificate expiration date.
     *
     * @return the expirationDate value.
     */
    public String expirationDate() {
        return this.expirationDate;
    }

    /**
     * Get the certificateAuthority property: Certificate issuing authority.
     *
     * @return the certificateAuthority value.
     */
    public String certificateAuthority() {
        return this.certificateAuthority;
    }

    /**
     * Get the subjectAlternativeNames property: The list of SANs.
     *
     * @return the subjectAlternativeNames value.
     */
    public List<String> subjectAlternativeNames() {
        return this.subjectAlternativeNames;
    }

    /**
     * Set the subjectAlternativeNames property: The list of SANs.
     *
     * @param subjectAlternativeNames the subjectAlternativeNames value to set.
     * @return the AzureFirstPartyManagedCertificateParameters object itself.
     */
    public AzureFirstPartyManagedCertificateParameters
        withSubjectAlternativeNames(List<String> subjectAlternativeNames) {
        this.subjectAlternativeNames = subjectAlternativeNames;
        return this;
    }

    /**
     * Get the thumbprint property: Certificate thumbprint.
     *
     * @return the thumbprint value.
     */
    public String thumbprint() {
        return this.thumbprint;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (secretSource() != null) {
            secretSource().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeArrayField("subjectAlternativeNames", this.subjectAlternativeNames,
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AzureFirstPartyManagedCertificateParameters from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AzureFirstPartyManagedCertificateParameters if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AzureFirstPartyManagedCertificateParameters.
     */
    public static AzureFirstPartyManagedCertificateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AzureFirstPartyManagedCertificateParameters deserializedAzureFirstPartyManagedCertificateParameters
                = new AzureFirstPartyManagedCertificateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedAzureFirstPartyManagedCertificateParameters.type
                        = SecretType.fromString(reader.getString());
                } else if ("secretSource".equals(fieldName)) {
                    deserializedAzureFirstPartyManagedCertificateParameters.secretSource
                        = ResourceReference.fromJson(reader);
                } else if ("subject".equals(fieldName)) {
                    deserializedAzureFirstPartyManagedCertificateParameters.subject = reader.getString();
                } else if ("expirationDate".equals(fieldName)) {
                    deserializedAzureFirstPartyManagedCertificateParameters.expirationDate = reader.getString();
                } else if ("certificateAuthority".equals(fieldName)) {
                    deserializedAzureFirstPartyManagedCertificateParameters.certificateAuthority = reader.getString();
                } else if ("subjectAlternativeNames".equals(fieldName)) {
                    List<String> subjectAlternativeNames = reader.readArray(reader1 -> reader1.getString());
                    deserializedAzureFirstPartyManagedCertificateParameters.subjectAlternativeNames
                        = subjectAlternativeNames;
                } else if ("thumbprint".equals(fieldName)) {
                    deserializedAzureFirstPartyManagedCertificateParameters.thumbprint = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAzureFirstPartyManagedCertificateParameters;
        });
    }
}
