/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.DeliveryRuleCondition;
import com.azure.resourcemanager.cdn.models.MatchVariable;
import com.azure.resourcemanager.cdn.models.RequestSchemeMatchConditionParameters;
import java.io.IOException;

public final class DeliveryRuleRequestSchemeCondition
extends DeliveryRuleCondition {
    private MatchVariable name = MatchVariable.REQUEST_SCHEME;
    private RequestSchemeMatchConditionParameters parameters;
    private static final ClientLogger LOGGER = new ClientLogger(DeliveryRuleRequestSchemeCondition.class);

    @Override
    public MatchVariable name() {
        return this.name;
    }

    public RequestSchemeMatchConditionParameters parameters() {
        return this.parameters;
    }

    public DeliveryRuleRequestSchemeCondition withParameters(RequestSchemeMatchConditionParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.parameters() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property parameters in model DeliveryRuleRequestSchemeCondition"));
        }
        this.parameters().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("parameters", (JsonSerializable)this.parameters);
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        return jsonWriter.writeEndObject();
    }

    public static DeliveryRuleRequestSchemeCondition fromJson(JsonReader jsonReader) throws IOException {
        return (DeliveryRuleRequestSchemeCondition)jsonReader.readObject(reader -> {
            DeliveryRuleRequestSchemeCondition deserializedDeliveryRuleRequestSchemeCondition = new DeliveryRuleRequestSchemeCondition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("parameters".equals(fieldName)) {
                    deserializedDeliveryRuleRequestSchemeCondition.parameters = RequestSchemeMatchConditionParameters.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDeliveryRuleRequestSchemeCondition.name = MatchVariable.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeliveryRuleRequestSchemeCondition;
        });
    }
}

