// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The WafRankingsResponseDataItem model.
 */
@Fluent
public final class WafRankingsResponseDataItem implements JsonSerializable<WafRankingsResponseDataItem> {
    /*
     * The groupValues property.
     */
    private List<String> groupValues;

    /*
     * The metrics property.
     */
    private List<WafRankingsResponseDataItemMetric> metrics;

    /**
     * Creates an instance of WafRankingsResponseDataItem class.
     */
    public WafRankingsResponseDataItem() {
    }

    /**
     * Get the groupValues property: The groupValues property.
     * 
     * @return the groupValues value.
     */
    public List<String> groupValues() {
        return this.groupValues;
    }

    /**
     * Set the groupValues property: The groupValues property.
     * 
     * @param groupValues the groupValues value to set.
     * @return the WafRankingsResponseDataItem object itself.
     */
    public WafRankingsResponseDataItem withGroupValues(List<String> groupValues) {
        this.groupValues = groupValues;
        return this;
    }

    /**
     * Get the metrics property: The metrics property.
     * 
     * @return the metrics value.
     */
    public List<WafRankingsResponseDataItemMetric> metrics() {
        return this.metrics;
    }

    /**
     * Set the metrics property: The metrics property.
     * 
     * @param metrics the metrics value to set.
     * @return the WafRankingsResponseDataItem object itself.
     */
    public WafRankingsResponseDataItem withMetrics(List<WafRankingsResponseDataItemMetric> metrics) {
        this.metrics = metrics;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (metrics() != null) {
            metrics().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("groupValues", this.groupValues, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("metrics", this.metrics, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WafRankingsResponseDataItem from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WafRankingsResponseDataItem if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the WafRankingsResponseDataItem.
     */
    public static WafRankingsResponseDataItem fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WafRankingsResponseDataItem deserializedWafRankingsResponseDataItem = new WafRankingsResponseDataItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("groupValues".equals(fieldName)) {
                    List<String> groupValues = reader.readArray(reader1 -> reader1.getString());
                    deserializedWafRankingsResponseDataItem.groupValues = groupValues;
                } else if ("metrics".equals(fieldName)) {
                    List<WafRankingsResponseDataItemMetric> metrics
                        = reader.readArray(reader1 -> WafRankingsResponseDataItemMetric.fromJson(reader1));
                    deserializedWafRankingsResponseDataItem.metrics = metrics;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWafRankingsResponseDataItem;
        });
    }
}
