// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The ResourcesResponseEndpointsItem model.
 */
@Fluent
public final class ResourcesResponseEndpointsItem implements JsonSerializable<ResourcesResponseEndpointsItem> {
    /*
     * The id property.
     */
    private String id;

    /*
     * The name property.
     */
    private String name;

    /*
     * The history property.
     */
    private Boolean history;

    /*
     * The customDomains property.
     */
    private List<ResourcesResponseEndpointsPropertiesItemsItem> customDomains;

    /**
     * Creates an instance of ResourcesResponseEndpointsItem class.
     */
    public ResourcesResponseEndpointsItem() {
    }

    /**
     * Get the id property: The id property.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: The id property.
     * 
     * @param id the id value to set.
     * @return the ResourcesResponseEndpointsItem object itself.
     */
    public ResourcesResponseEndpointsItem withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the name property: The name property.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name property.
     * 
     * @param name the name value to set.
     * @return the ResourcesResponseEndpointsItem object itself.
     */
    public ResourcesResponseEndpointsItem withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the history property: The history property.
     * 
     * @return the history value.
     */
    public Boolean history() {
        return this.history;
    }

    /**
     * Set the history property: The history property.
     * 
     * @param history the history value to set.
     * @return the ResourcesResponseEndpointsItem object itself.
     */
    public ResourcesResponseEndpointsItem withHistory(Boolean history) {
        this.history = history;
        return this;
    }

    /**
     * Get the customDomains property: The customDomains property.
     * 
     * @return the customDomains value.
     */
    public List<ResourcesResponseEndpointsPropertiesItemsItem> customDomains() {
        return this.customDomains;
    }

    /**
     * Set the customDomains property: The customDomains property.
     * 
     * @param customDomains the customDomains value to set.
     * @return the ResourcesResponseEndpointsItem object itself.
     */
    public ResourcesResponseEndpointsItem
        withCustomDomains(List<ResourcesResponseEndpointsPropertiesItemsItem> customDomains) {
        this.customDomains = customDomains;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (customDomains() != null) {
            customDomains().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeBooleanField("history", this.history);
        jsonWriter.writeArrayField("customDomains", this.customDomains, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResourcesResponseEndpointsItem from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResourcesResponseEndpointsItem if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ResourcesResponseEndpointsItem.
     */
    public static ResourcesResponseEndpointsItem fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResourcesResponseEndpointsItem deserializedResourcesResponseEndpointsItem
                = new ResourcesResponseEndpointsItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedResourcesResponseEndpointsItem.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedResourcesResponseEndpointsItem.name = reader.getString();
                } else if ("history".equals(fieldName)) {
                    deserializedResourcesResponseEndpointsItem.history = reader.getNullable(JsonReader::getBoolean);
                } else if ("customDomains".equals(fieldName)) {
                    List<ResourcesResponseEndpointsPropertiesItemsItem> customDomains
                        = reader.readArray(reader1 -> ResourcesResponseEndpointsPropertiesItemsItem.fromJson(reader1));
                    deserializedResourcesResponseEndpointsItem.customDomains = customDomains;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedResourcesResponseEndpointsItem;
        });
    }
}
