// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.fluent.models.ProfilePropertiesUpdateParameters;
import java.io.IOException;
import java.util.Map;

/**
 * Properties required to update a profile.
 */
@Fluent
public final class ProfileUpdateParameters implements JsonSerializable<ProfileUpdateParameters> {
    /*
     * Profile tags
     */
    private Map<String, String> tags;

    /*
     * Managed service identity (system assigned and/or user assigned identities).
     */
    private ManagedServiceIdentity identity;

    /*
     * The JSON object containing profile update parameters.
     */
    private ProfilePropertiesUpdateParameters innerProperties;

    /**
     * Creates an instance of ProfileUpdateParameters class.
     */
    public ProfileUpdateParameters() {
    }

    /**
     * Get the tags property: Profile tags.
     * 
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: Profile tags.
     * 
     * @param tags the tags value to set.
     * @return the ProfileUpdateParameters object itself.
     */
    public ProfileUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the identity property: Managed service identity (system assigned and/or user assigned identities).
     * 
     * @return the identity value.
     */
    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    /**
     * Set the identity property: Managed service identity (system assigned and/or user assigned identities).
     * 
     * @param identity the identity value to set.
     * @return the ProfileUpdateParameters object itself.
     */
    public ProfileUpdateParameters withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Get the innerProperties property: The JSON object containing profile update parameters.
     * 
     * @return the innerProperties value.
     */
    private ProfilePropertiesUpdateParameters innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the originResponseTimeoutSeconds property: Send and receive timeout on forwarding request to the origin. When
     * timeout is reached, the request fails and returns.
     * 
     * @return the originResponseTimeoutSeconds value.
     */
    public Integer originResponseTimeoutSeconds() {
        return this.innerProperties() == null ? null : this.innerProperties().originResponseTimeoutSeconds();
    }

    /**
     * Set the originResponseTimeoutSeconds property: Send and receive timeout on forwarding request to the origin. When
     * timeout is reached, the request fails and returns.
     * 
     * @param originResponseTimeoutSeconds the originResponseTimeoutSeconds value to set.
     * @return the ProfileUpdateParameters object itself.
     */
    public ProfileUpdateParameters withOriginResponseTimeoutSeconds(Integer originResponseTimeoutSeconds) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProfilePropertiesUpdateParameters();
        }
        this.innerProperties().withOriginResponseTimeoutSeconds(originResponseTimeoutSeconds);
        return this;
    }

    /**
     * Get the logScrubbing property: Defines rules to scrub sensitive fields in logs.
     * 
     * @return the logScrubbing value.
     */
    public ProfileLogScrubbing logScrubbing() {
        return this.innerProperties() == null ? null : this.innerProperties().logScrubbing();
    }

    /**
     * Set the logScrubbing property: Defines rules to scrub sensitive fields in logs.
     * 
     * @param logScrubbing the logScrubbing value to set.
     * @return the ProfileUpdateParameters object itself.
     */
    public ProfileUpdateParameters withLogScrubbing(ProfileLogScrubbing logScrubbing) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProfilePropertiesUpdateParameters();
        }
        this.innerProperties().withLogScrubbing(logScrubbing);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (identity() != null) {
            identity().validate();
        }
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("identity", this.identity);
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ProfileUpdateParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ProfileUpdateParameters if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ProfileUpdateParameters.
     */
    public static ProfileUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ProfileUpdateParameters deserializedProfileUpdateParameters = new ProfileUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedProfileUpdateParameters.tags = tags;
                } else if ("identity".equals(fieldName)) {
                    deserializedProfileUpdateParameters.identity = ManagedServiceIdentity.fromJson(reader);
                } else if ("properties".equals(fieldName)) {
                    deserializedProfileUpdateParameters.innerProperties
                        = ProfilePropertiesUpdateParameters.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedProfileUpdateParameters;
        });
    }
}
