// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Request body for Migrate operation.
 */
@Fluent
public final class MigrationParameters implements JsonSerializable<MigrationParameters> {
    /*
     * Sku for the migration
     */
    private Sku sku;

    /*
     * Resource reference of the classic cdn profile or classic frontdoor that need to be migrated.
     */
    private ResourceReference classicResourceReference;

    /*
     * Name of the new profile that need to be created.
     */
    private String profileName;

    /*
     * Waf mapping for the migrated profile
     */
    private List<MigrationWebApplicationFirewallMapping> migrationWebApplicationFirewallMappings;

    /**
     * Creates an instance of MigrationParameters class.
     */
    public MigrationParameters() {
    }

    /**
     * Get the sku property: Sku for the migration.
     * 
     * @return the sku value.
     */
    public Sku sku() {
        return this.sku;
    }

    /**
     * Set the sku property: Sku for the migration.
     * 
     * @param sku the sku value to set.
     * @return the MigrationParameters object itself.
     */
    public MigrationParameters withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    /**
     * Get the classicResourceReference property: Resource reference of the classic cdn profile or classic frontdoor
     * that need to be migrated.
     * 
     * @return the classicResourceReference value.
     */
    public ResourceReference classicResourceReference() {
        return this.classicResourceReference;
    }

    /**
     * Set the classicResourceReference property: Resource reference of the classic cdn profile or classic frontdoor
     * that need to be migrated.
     * 
     * @param classicResourceReference the classicResourceReference value to set.
     * @return the MigrationParameters object itself.
     */
    public MigrationParameters withClassicResourceReference(ResourceReference classicResourceReference) {
        this.classicResourceReference = classicResourceReference;
        return this;
    }

    /**
     * Get the profileName property: Name of the new profile that need to be created.
     * 
     * @return the profileName value.
     */
    public String profileName() {
        return this.profileName;
    }

    /**
     * Set the profileName property: Name of the new profile that need to be created.
     * 
     * @param profileName the profileName value to set.
     * @return the MigrationParameters object itself.
     */
    public MigrationParameters withProfileName(String profileName) {
        this.profileName = profileName;
        return this;
    }

    /**
     * Get the migrationWebApplicationFirewallMappings property: Waf mapping for the migrated profile.
     * 
     * @return the migrationWebApplicationFirewallMappings value.
     */
    public List<MigrationWebApplicationFirewallMapping> migrationWebApplicationFirewallMappings() {
        return this.migrationWebApplicationFirewallMappings;
    }

    /**
     * Set the migrationWebApplicationFirewallMappings property: Waf mapping for the migrated profile.
     * 
     * @param migrationWebApplicationFirewallMappings the migrationWebApplicationFirewallMappings value to set.
     * @return the MigrationParameters object itself.
     */
    public MigrationParameters withMigrationWebApplicationFirewallMappings(
        List<MigrationWebApplicationFirewallMapping> migrationWebApplicationFirewallMappings) {
        this.migrationWebApplicationFirewallMappings = migrationWebApplicationFirewallMappings;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (sku() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property sku in model MigrationParameters"));
        } else {
            sku().validate();
        }
        if (classicResourceReference() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property classicResourceReference in model MigrationParameters"));
        } else {
            classicResourceReference().validate();
        }
        if (profileName() == null) {
            throw LOGGER.atError()
                .log(
                    new IllegalArgumentException("Missing required property profileName in model MigrationParameters"));
        }
        if (migrationWebApplicationFirewallMappings() != null) {
            migrationWebApplicationFirewallMappings().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(MigrationParameters.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sku", this.sku);
        jsonWriter.writeJsonField("classicResourceReference", this.classicResourceReference);
        jsonWriter.writeStringField("profileName", this.profileName);
        jsonWriter.writeArrayField("migrationWebApplicationFirewallMappings",
            this.migrationWebApplicationFirewallMappings, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MigrationParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MigrationParameters if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the MigrationParameters.
     */
    public static MigrationParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MigrationParameters deserializedMigrationParameters = new MigrationParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("sku".equals(fieldName)) {
                    deserializedMigrationParameters.sku = Sku.fromJson(reader);
                } else if ("classicResourceReference".equals(fieldName)) {
                    deserializedMigrationParameters.classicResourceReference = ResourceReference.fromJson(reader);
                } else if ("profileName".equals(fieldName)) {
                    deserializedMigrationParameters.profileName = reader.getString();
                } else if ("migrationWebApplicationFirewallMappings".equals(fieldName)) {
                    List<MigrationWebApplicationFirewallMapping> migrationWebApplicationFirewallMappings
                        = reader.readArray(reader1 -> MigrationWebApplicationFirewallMapping.fromJson(reader1));
                    deserializedMigrationParameters.migrationWebApplicationFirewallMappings
                        = migrationWebApplicationFirewallMappings;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMigrationParameters;
        });
    }
}
