// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * settings for compression.
 */
@Fluent
public final class CompressionSettings implements JsonSerializable<CompressionSettings> {
    /*
     * List of content types on which compression applies. The value should be a valid MIME type.
     */
    private List<String> contentTypesToCompress;

    /*
     * Indicates whether content compression is enabled on AzureFrontDoor. Default value is false. If compression is
     * enabled, content will be served as compressed if user requests for a compressed version. Content won't be
     * compressed on AzureFrontDoor when requested content is smaller than 1 byte or larger than 1 MB.
     */
    private Boolean isCompressionEnabled;

    /**
     * Creates an instance of CompressionSettings class.
     */
    public CompressionSettings() {
    }

    /**
     * Get the contentTypesToCompress property: List of content types on which compression applies. The value should be
     * a valid MIME type.
     * 
     * @return the contentTypesToCompress value.
     */
    public List<String> contentTypesToCompress() {
        return this.contentTypesToCompress;
    }

    /**
     * Set the contentTypesToCompress property: List of content types on which compression applies. The value should be
     * a valid MIME type.
     * 
     * @param contentTypesToCompress the contentTypesToCompress value to set.
     * @return the CompressionSettings object itself.
     */
    public CompressionSettings withContentTypesToCompress(List<String> contentTypesToCompress) {
        this.contentTypesToCompress = contentTypesToCompress;
        return this;
    }

    /**
     * Get the isCompressionEnabled property: Indicates whether content compression is enabled on AzureFrontDoor.
     * Default value is false. If compression is enabled, content will be served as compressed if user requests for a
     * compressed version. Content won't be compressed on AzureFrontDoor when requested content is smaller than 1 byte
     * or larger than 1 MB.
     * 
     * @return the isCompressionEnabled value.
     */
    public Boolean isCompressionEnabled() {
        return this.isCompressionEnabled;
    }

    /**
     * Set the isCompressionEnabled property: Indicates whether content compression is enabled on AzureFrontDoor.
     * Default value is false. If compression is enabled, content will be served as compressed if user requests for a
     * compressed version. Content won't be compressed on AzureFrontDoor when requested content is smaller than 1 byte
     * or larger than 1 MB.
     * 
     * @param isCompressionEnabled the isCompressionEnabled value to set.
     * @return the CompressionSettings object itself.
     */
    public CompressionSettings withIsCompressionEnabled(Boolean isCompressionEnabled) {
        this.isCompressionEnabled = isCompressionEnabled;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("contentTypesToCompress", this.contentTypesToCompress,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("isCompressionEnabled", this.isCompressionEnabled);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CompressionSettings from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CompressionSettings if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the CompressionSettings.
     */
    public static CompressionSettings fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CompressionSettings deserializedCompressionSettings = new CompressionSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("contentTypesToCompress".equals(fieldName)) {
                    List<String> contentTypesToCompress = reader.readArray(reader1 -> reader1.getString());
                    deserializedCompressionSettings.contentTypesToCompress = contentTypesToCompress;
                } else if ("isCompressionEnabled".equals(fieldName)) {
                    deserializedCompressionSettings.isCompressionEnabled = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCompressionSettings;
        });
    }
}
