// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Certificate used for https.
 */
@Fluent
public class Certificate implements JsonSerializable<Certificate> {
    /*
     * The type of the secret resource.
     */
    private SecretType type;

    /*
     * Subject name in the certificate.
     */
    private String subject;

    /*
     * Certificate expiration date.
     */
    private String expirationDate;

    /**
     * Creates an instance of Certificate class.
     */
    public Certificate() {
    }

    /**
     * Get the type property: The type of the secret resource.
     * 
     * @return the type value.
     */
    public SecretType type() {
        return this.type;
    }

    /**
     * Set the type property: The type of the secret resource.
     * 
     * @param type the type value to set.
     * @return the Certificate object itself.
     */
    public Certificate withType(SecretType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the subject property: Subject name in the certificate.
     * 
     * @return the subject value.
     */
    public String subject() {
        return this.subject;
    }

    /**
     * Set the subject property: Subject name in the certificate.
     * 
     * @param subject the subject value to set.
     * @return the Certificate object itself.
     */
    Certificate withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    /**
     * Get the expirationDate property: Certificate expiration date.
     * 
     * @return the expirationDate value.
     */
    public String expirationDate() {
        return this.expirationDate;
    }

    /**
     * Set the expirationDate property: Certificate expiration date.
     * 
     * @param expirationDate the expirationDate value to set.
     * @return the Certificate object itself.
     */
    Certificate withExpirationDate(String expirationDate) {
        this.expirationDate = expirationDate;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Certificate from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Certificate if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the Certificate.
     */
    public static Certificate fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Certificate deserializedCertificate = new Certificate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedCertificate.type = SecretType.fromString(reader.getString());
                } else if ("subject".equals(fieldName)) {
                    deserializedCertificate.subject = reader.getString();
                } else if ("expirationDate".equals(fieldName)) {
                    deserializedCertificate.expirationDate = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCertificate;
        });
    }
}
