// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.fluent.models.AfdEndpointPropertiesUpdateParameters;
import java.io.IOException;
import java.util.Map;

/**
 * Properties required to create or update an endpoint.
 */
@Fluent
public final class AfdEndpointUpdateParameters implements JsonSerializable<AfdEndpointUpdateParameters> {
    /*
     * Endpoint tags.
     */
    private Map<String, String> tags;

    /*
     * The JSON object containing endpoint update parameters.
     */
    private AfdEndpointPropertiesUpdateParameters innerProperties;

    /**
     * Creates an instance of AfdEndpointUpdateParameters class.
     */
    public AfdEndpointUpdateParameters() {
    }

    /**
     * Get the tags property: Endpoint tags.
     * 
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: Endpoint tags.
     * 
     * @param tags the tags value to set.
     * @return the AfdEndpointUpdateParameters object itself.
     */
    public AfdEndpointUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the innerProperties property: The JSON object containing endpoint update parameters.
     * 
     * @return the innerProperties value.
     */
    private AfdEndpointPropertiesUpdateParameters innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the profileName property: The name of the profile which holds the endpoint.
     * 
     * @return the profileName value.
     */
    public String profileName() {
        return this.innerProperties() == null ? null : this.innerProperties().profileName();
    }

    /**
     * Get the enabledState property: Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'.
     * 
     * @return the enabledState value.
     */
    public EnabledState enabledState() {
        return this.innerProperties() == null ? null : this.innerProperties().enabledState();
    }

    /**
     * Set the enabledState property: Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'.
     * 
     * @param enabledState the enabledState value to set.
     * @return the AfdEndpointUpdateParameters object itself.
     */
    public AfdEndpointUpdateParameters withEnabledState(EnabledState enabledState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AfdEndpointPropertiesUpdateParameters();
        }
        this.innerProperties().withEnabledState(enabledState);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AfdEndpointUpdateParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AfdEndpointUpdateParameters if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AfdEndpointUpdateParameters.
     */
    public static AfdEndpointUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AfdEndpointUpdateParameters deserializedAfdEndpointUpdateParameters = new AfdEndpointUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedAfdEndpointUpdateParameters.tags = tags;
                } else if ("properties".equals(fieldName)) {
                    deserializedAfdEndpointUpdateParameters.innerProperties
                        = AfdEndpointPropertiesUpdateParameters.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAfdEndpointUpdateParameters;
        });
    }
}
