// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.fluent.models.CustomDomainPropertiesParameters;
import java.io.IOException;

/**
 * The customDomain JSON object required for custom domain creation or update.
 */
@Fluent
public final class CustomDomainParameters implements JsonSerializable<CustomDomainParameters> {
    /*
     * The JSON object that contains the properties of the custom domain to create.
     */
    private CustomDomainPropertiesParameters innerProperties;

    /**
     * Creates an instance of CustomDomainParameters class.
     */
    public CustomDomainParameters() {
    }

    /**
     * Get the innerProperties property: The JSON object that contains the properties of the custom domain to create.
     * 
     * @return the innerProperties value.
     */
    private CustomDomainPropertiesParameters innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the hostname property: The host name of the custom domain. Must be a domain name.
     * 
     * @return the hostname value.
     */
    public String hostname() {
        return this.innerProperties() == null ? null : this.innerProperties().hostname();
    }

    /**
     * Set the hostname property: The host name of the custom domain. Must be a domain name.
     * 
     * @param hostname the hostname value to set.
     * @return the CustomDomainParameters object itself.
     */
    public CustomDomainParameters withHostname(String hostname) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CustomDomainPropertiesParameters();
        }
        this.innerProperties().withHostname(hostname);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CustomDomainParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CustomDomainParameters if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CustomDomainParameters.
     */
    public static CustomDomainParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CustomDomainParameters deserializedCustomDomainParameters = new CustomDomainParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("properties".equals(fieldName)) {
                    deserializedCustomDomainParameters.innerProperties
                        = CustomDomainPropertiesParameters.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCustomDomainParameters;
        });
    }
}
