// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Defines the parameters for the origin group override action.
 */
@Fluent
public final class OriginGroupOverrideActionParameters
    implements JsonSerializable<OriginGroupOverrideActionParameters> {
    /*
     * The typeName property.
     */
    private String typeName = "DeliveryRuleOriginGroupOverrideActionParameters";

    /*
     * defines the OriginGroup that would override the DefaultOriginGroup.
     */
    private ResourceReference originGroup;

    /**
     * Creates an instance of OriginGroupOverrideActionParameters class.
     */
    public OriginGroupOverrideActionParameters() {
    }

    /**
     * Get the typeName property: The typeName property.
     * 
     * @return the typeName value.
     */
    public String typeName() {
        return this.typeName;
    }

    /**
     * Set the typeName property: The typeName property.
     * 
     * @param typeName the typeName value to set.
     * @return the OriginGroupOverrideActionParameters object itself.
     */
    public OriginGroupOverrideActionParameters withTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    /**
     * Get the originGroup property: defines the OriginGroup that would override the DefaultOriginGroup.
     * 
     * @return the originGroup value.
     */
    public ResourceReference originGroup() {
        return this.originGroup;
    }

    /**
     * Set the originGroup property: defines the OriginGroup that would override the DefaultOriginGroup.
     * 
     * @param originGroup the originGroup value to set.
     * @return the OriginGroupOverrideActionParameters object itself.
     */
    public OriginGroupOverrideActionParameters withOriginGroup(ResourceReference originGroup) {
        this.originGroup = originGroup;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (originGroup() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property originGroup in model OriginGroupOverrideActionParameters"));
        } else {
            originGroup().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(OriginGroupOverrideActionParameters.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("typeName", this.typeName);
        jsonWriter.writeJsonField("originGroup", this.originGroup);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OriginGroupOverrideActionParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of OriginGroupOverrideActionParameters if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the OriginGroupOverrideActionParameters.
     */
    public static OriginGroupOverrideActionParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OriginGroupOverrideActionParameters deserializedOriginGroupOverrideActionParameters
                = new OriginGroupOverrideActionParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("originGroup".equals(fieldName)) {
                    deserializedOriginGroupOverrideActionParameters.originGroup = ResourceReference.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOriginGroupOverrideActionParameters;
        });
    }
}
