// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Managed Certificate used for https.
 */
@Fluent
public final class ManagedCertificate extends Certificate {
    /*
     * Certificate expiration date.
     */
    private String expirationDate;

    /*
     * Subject name in the certificate.
     */
    private String subject;

    /**
     * Creates an instance of ManagedCertificate class.
     */
    public ManagedCertificate() {
    }

    /**
     * Get the expirationDate property: Certificate expiration date.
     * 
     * @return the expirationDate value.
     */
    @Override
    public String expirationDate() {
        return this.expirationDate;
    }

    /**
     * Get the subject property: Subject name in the certificate.
     * 
     * @return the subject value.
     */
    @Override
    public String subject() {
        return this.subject;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ManagedCertificate withType(SecretType type) {
        super.withType(type);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", type() == null ? null : type().toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedCertificate from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedCertificate if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ManagedCertificate.
     */
    public static ManagedCertificate fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedCertificate deserializedManagedCertificate = new ManagedCertificate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedManagedCertificate.withType(SecretType.fromString(reader.getString()));
                } else if ("subject".equals(fieldName)) {
                    deserializedManagedCertificate.subject = reader.getString();
                } else if ("expirationDate".equals(fieldName)) {
                    deserializedManagedCertificate.expirationDate = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedCertificate;
        });
    }
}
