// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.ResourceReference;
import java.io.IOException;

/**
 * The MigrateResultProperties model.
 */
@Immutable
public final class MigrateResultProperties implements JsonSerializable<MigrateResultProperties> {
    /*
     * Arm resource id of the migrated profile
     */
    private ResourceReference migratedProfileResourceId;

    /**
     * Creates an instance of MigrateResultProperties class.
     */
    public MigrateResultProperties() {
    }

    /**
     * Get the migratedProfileResourceId property: Arm resource id of the migrated profile.
     * 
     * @return the migratedProfileResourceId value.
     */
    public ResourceReference migratedProfileResourceId() {
        return this.migratedProfileResourceId;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (migratedProfileResourceId() != null) {
            migratedProfileResourceId().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MigrateResultProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MigrateResultProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MigrateResultProperties.
     */
    public static MigrateResultProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MigrateResultProperties deserializedMigrateResultProperties = new MigrateResultProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("migratedProfileResourceId".equals(fieldName)) {
                    deserializedMigrateResultProperties.migratedProfileResourceId = ResourceReference.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMigrateResultProperties;
        });
    }
}
