// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.cdn.fluent.models.CheckEndpointNameAvailabilityOutputInner;
import com.azure.resourcemanager.cdn.fluent.models.CheckNameAvailabilityOutputInner;
import com.azure.resourcemanager.cdn.fluent.models.ProfileInner;
import com.azure.resourcemanager.cdn.fluent.models.UsageInner;
import com.azure.resourcemanager.cdn.fluent.models.ValidateSecretOutputInner;
import com.azure.resourcemanager.cdn.models.CheckEndpointNameAvailabilityInput;
import com.azure.resourcemanager.cdn.models.CheckHostnameAvailabilityInput;
import com.azure.resourcemanager.cdn.models.ProfileUpgradeParameters;
import com.azure.resourcemanager.cdn.models.ValidateSecretInput;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in AfdProfilesClient.
 */
public interface AfdProfilesClient {
    /**
     * Check the availability of an afdx endpoint name, and return the globally unique endpoint host name.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium which is unique within the
     * resource group.
     * @param checkEndpointNameAvailabilityInput Input to check.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return output of check name availability API along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<CheckEndpointNameAvailabilityOutputInner>> checkEndpointNameAvailabilityWithResponseAsync(
        String resourceGroupName, String profileName,
        CheckEndpointNameAvailabilityInput checkEndpointNameAvailabilityInput);

    /**
     * Check the availability of an afdx endpoint name, and return the globally unique endpoint host name.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium which is unique within the
     * resource group.
     * @param checkEndpointNameAvailabilityInput Input to check.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return output of check name availability API on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<CheckEndpointNameAvailabilityOutputInner> checkEndpointNameAvailabilityAsync(String resourceGroupName,
        String profileName, CheckEndpointNameAvailabilityInput checkEndpointNameAvailabilityInput);

    /**
     * Check the availability of an afdx endpoint name, and return the globally unique endpoint host name.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium which is unique within the
     * resource group.
     * @param checkEndpointNameAvailabilityInput Input to check.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return output of check name availability API along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<CheckEndpointNameAvailabilityOutputInner> checkEndpointNameAvailabilityWithResponse(
        String resourceGroupName, String profileName,
        CheckEndpointNameAvailabilityInput checkEndpointNameAvailabilityInput, Context context);

    /**
     * Check the availability of an afdx endpoint name, and return the globally unique endpoint host name.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium which is unique within the
     * resource group.
     * @param checkEndpointNameAvailabilityInput Input to check.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return output of check name availability API.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    CheckEndpointNameAvailabilityOutputInner checkEndpointNameAvailability(String resourceGroupName, String profileName,
        CheckEndpointNameAvailabilityInput checkEndpointNameAvailabilityInput);

    /**
     * Checks the quota and actual usage of endpoints under the given Azure Front Door profile.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
     * within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list usages operation response as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<UsageInner> listResourceUsageAsync(String resourceGroupName, String profileName);

    /**
     * Checks the quota and actual usage of endpoints under the given Azure Front Door profile.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
     * within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list usages operation response as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<UsageInner> listResourceUsage(String resourceGroupName, String profileName);

    /**
     * Checks the quota and actual usage of endpoints under the given Azure Front Door profile.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
     * within the resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list usages operation response as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<UsageInner> listResourceUsage(String resourceGroupName, String profileName, Context context);

    /**
     * Validates the custom domain mapping to ensure it maps to the correct Azure Front Door endpoint in DNS.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
     * within the resource group.
     * @param checkHostnameAvailabilityInput Custom domain to be validated.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return output of check name availability API along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<CheckNameAvailabilityOutputInner>> checkHostnameAvailabilityWithResponseAsync(
        String resourceGroupName, String profileName, CheckHostnameAvailabilityInput checkHostnameAvailabilityInput);

    /**
     * Validates the custom domain mapping to ensure it maps to the correct Azure Front Door endpoint in DNS.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
     * within the resource group.
     * @param checkHostnameAvailabilityInput Custom domain to be validated.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return output of check name availability API on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<CheckNameAvailabilityOutputInner> checkHostnameAvailabilityAsync(String resourceGroupName, String profileName,
        CheckHostnameAvailabilityInput checkHostnameAvailabilityInput);

    /**
     * Validates the custom domain mapping to ensure it maps to the correct Azure Front Door endpoint in DNS.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
     * within the resource group.
     * @param checkHostnameAvailabilityInput Custom domain to be validated.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return output of check name availability API along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<CheckNameAvailabilityOutputInner> checkHostnameAvailabilityWithResponse(String resourceGroupName,
        String profileName, CheckHostnameAvailabilityInput checkHostnameAvailabilityInput, Context context);

    /**
     * Validates the custom domain mapping to ensure it maps to the correct Azure Front Door endpoint in DNS.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
     * within the resource group.
     * @param checkHostnameAvailabilityInput Custom domain to be validated.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return output of check name availability API.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    CheckNameAvailabilityOutputInner checkHostnameAvailability(String resourceGroupName, String profileName,
        CheckHostnameAvailabilityInput checkHostnameAvailabilityInput);

    /**
     * Validate a Secret in the profile.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium which is unique within the
     * resource group.
     * @param validateSecretInput The Secret source.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return output of the validated secret along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ValidateSecretOutputInner>> validateSecretWithResponseAsync(String resourceGroupName,
        String profileName, ValidateSecretInput validateSecretInput);

    /**
     * Validate a Secret in the profile.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium which is unique within the
     * resource group.
     * @param validateSecretInput The Secret source.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return output of the validated secret on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ValidateSecretOutputInner> validateSecretAsync(String resourceGroupName, String profileName,
        ValidateSecretInput validateSecretInput);

    /**
     * Validate a Secret in the profile.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium which is unique within the
     * resource group.
     * @param validateSecretInput The Secret source.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return output of the validated secret along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ValidateSecretOutputInner> validateSecretWithResponse(String resourceGroupName, String profileName,
        ValidateSecretInput validateSecretInput, Context context);

    /**
     * Validate a Secret in the profile.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium which is unique within the
     * resource group.
     * @param validateSecretInput The Secret source.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return output of the validated secret.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ValidateSecretOutputInner validateSecret(String resourceGroupName, String profileName,
        ValidateSecretInput validateSecretInput);

    /**
     * Upgrade a profile from Standard_AzureFrontDoor to Premium_AzureFrontDoor.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium which is unique within the
     * resource group.
     * @param profileUpgradeParameters Profile upgrade input parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a profile is a logical grouping of endpoints that share the same settings along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> upgradeWithResponseAsync(String resourceGroupName, String profileName,
        ProfileUpgradeParameters profileUpgradeParameters);

    /**
     * Upgrade a profile from Standard_AzureFrontDoor to Premium_AzureFrontDoor.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium which is unique within the
     * resource group.
     * @param profileUpgradeParameters Profile upgrade input parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of a profile is a logical grouping of endpoints that share the same
     * settings.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<ProfileInner>, ProfileInner> beginUpgradeAsync(String resourceGroupName, String profileName,
        ProfileUpgradeParameters profileUpgradeParameters);

    /**
     * Upgrade a profile from Standard_AzureFrontDoor to Premium_AzureFrontDoor.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium which is unique within the
     * resource group.
     * @param profileUpgradeParameters Profile upgrade input parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of a profile is a logical grouping of endpoints that share the same
     * settings.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<ProfileInner>, ProfileInner> beginUpgrade(String resourceGroupName, String profileName,
        ProfileUpgradeParameters profileUpgradeParameters);

    /**
     * Upgrade a profile from Standard_AzureFrontDoor to Premium_AzureFrontDoor.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium which is unique within the
     * resource group.
     * @param profileUpgradeParameters Profile upgrade input parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of a profile is a logical grouping of endpoints that share the same
     * settings.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<ProfileInner>, ProfileInner> beginUpgrade(String resourceGroupName, String profileName,
        ProfileUpgradeParameters profileUpgradeParameters, Context context);

    /**
     * Upgrade a profile from Standard_AzureFrontDoor to Premium_AzureFrontDoor.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium which is unique within the
     * resource group.
     * @param profileUpgradeParameters Profile upgrade input parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a profile is a logical grouping of endpoints that share the same settings on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ProfileInner> upgradeAsync(String resourceGroupName, String profileName,
        ProfileUpgradeParameters profileUpgradeParameters);

    /**
     * Upgrade a profile from Standard_AzureFrontDoor to Premium_AzureFrontDoor.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium which is unique within the
     * resource group.
     * @param profileUpgradeParameters Profile upgrade input parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a profile is a logical grouping of endpoints that share the same settings.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ProfileInner upgrade(String resourceGroupName, String profileName,
        ProfileUpgradeParameters profileUpgradeParameters);

    /**
     * Upgrade a profile from Standard_AzureFrontDoor to Premium_AzureFrontDoor.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium which is unique within the
     * resource group.
     * @param profileUpgradeParameters Profile upgrade input parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a profile is a logical grouping of endpoints that share the same settings.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ProfileInner upgrade(String resourceGroupName, String profileName,
        ProfileUpgradeParameters profileUpgradeParameters, Context context);
}
