/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.ResourceReference;
import com.azure.resourcemanager.cdn.models.SecretParameters;
import com.azure.resourcemanager.cdn.models.SecretType;
import java.io.IOException;
import java.util.List;

public final class CustomerCertificateParameters
extends SecretParameters {
    private SecretType type = SecretType.CUSTOMER_CERTIFICATE;
    private ResourceReference secretSource;
    private String secretVersion;
    private Boolean useLatestVersion;
    private String subject;
    private String expirationDate;
    private String certificateAuthority;
    private List<String> subjectAlternativeNames;
    private String thumbprint;
    private static final ClientLogger LOGGER = new ClientLogger(CustomerCertificateParameters.class);

    @Override
    public SecretType type() {
        return this.type;
    }

    public ResourceReference secretSource() {
        return this.secretSource;
    }

    public CustomerCertificateParameters withSecretSource(ResourceReference secretSource) {
        this.secretSource = secretSource;
        return this;
    }

    public String secretVersion() {
        return this.secretVersion;
    }

    public CustomerCertificateParameters withSecretVersion(String secretVersion) {
        this.secretVersion = secretVersion;
        return this;
    }

    public Boolean useLatestVersion() {
        return this.useLatestVersion;
    }

    public CustomerCertificateParameters withUseLatestVersion(Boolean useLatestVersion) {
        this.useLatestVersion = useLatestVersion;
        return this;
    }

    public String subject() {
        return this.subject;
    }

    public String expirationDate() {
        return this.expirationDate;
    }

    public String certificateAuthority() {
        return this.certificateAuthority;
    }

    public List<String> subjectAlternativeNames() {
        return this.subjectAlternativeNames;
    }

    public CustomerCertificateParameters withSubjectAlternativeNames(List<String> subjectAlternativeNames) {
        this.subjectAlternativeNames = subjectAlternativeNames;
        return this;
    }

    public String thumbprint() {
        return this.thumbprint;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.secretSource() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property secretSource in model CustomerCertificateParameters"));
        }
        this.secretSource().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("secretSource", (JsonSerializable)this.secretSource);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("secretVersion", this.secretVersion);
        jsonWriter.writeBooleanField("useLatestVersion", this.useLatestVersion);
        jsonWriter.writeArrayField("subjectAlternativeNames", this.subjectAlternativeNames, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static CustomerCertificateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (CustomerCertificateParameters)jsonReader.readObject(reader -> {
            CustomerCertificateParameters deserializedCustomerCertificateParameters = new CustomerCertificateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("secretSource".equals(fieldName)) {
                    deserializedCustomerCertificateParameters.secretSource = ResourceReference.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCustomerCertificateParameters.type = SecretType.fromString(reader.getString());
                    continue;
                }
                if ("secretVersion".equals(fieldName)) {
                    deserializedCustomerCertificateParameters.secretVersion = reader.getString();
                    continue;
                }
                if ("useLatestVersion".equals(fieldName)) {
                    deserializedCustomerCertificateParameters.useLatestVersion = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("subject".equals(fieldName)) {
                    deserializedCustomerCertificateParameters.subject = reader.getString();
                    continue;
                }
                if ("expirationDate".equals(fieldName)) {
                    deserializedCustomerCertificateParameters.expirationDate = reader.getString();
                    continue;
                }
                if ("certificateAuthority".equals(fieldName)) {
                    deserializedCustomerCertificateParameters.certificateAuthority = reader.getString();
                    continue;
                }
                if ("subjectAlternativeNames".equals(fieldName)) {
                    List subjectAlternativeNames;
                    deserializedCustomerCertificateParameters.subjectAlternativeNames = subjectAlternativeNames = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("thumbprint".equals(fieldName)) {
                    deserializedCustomerCertificateParameters.thumbprint = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCustomerCertificateParameters;
        });
    }
}

