// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Url signing key.
 */
@Fluent
public final class UrlSigningKey implements JsonSerializable<UrlSigningKey> {
    /*
     * Defines the customer defined key Id. This id will exist in the incoming request to indicate the key used to form
     * the hash.
     */
    private String keyId;

    /*
     * Defines the parameters for using customer key vault for Url Signing Key.
     */
    private KeyVaultSigningKeyParameters keySourceParameters;

    /**
     * Creates an instance of UrlSigningKey class.
     */
    public UrlSigningKey() {
    }

    /**
     * Get the keyId property: Defines the customer defined key Id. This id will exist in the incoming request to
     * indicate the key used to form the hash.
     * 
     * @return the keyId value.
     */
    public String keyId() {
        return this.keyId;
    }

    /**
     * Set the keyId property: Defines the customer defined key Id. This id will exist in the incoming request to
     * indicate the key used to form the hash.
     * 
     * @param keyId the keyId value to set.
     * @return the UrlSigningKey object itself.
     */
    public UrlSigningKey withKeyId(String keyId) {
        this.keyId = keyId;
        return this;
    }

    /**
     * Get the keySourceParameters property: Defines the parameters for using customer key vault for Url Signing Key.
     * 
     * @return the keySourceParameters value.
     */
    public KeyVaultSigningKeyParameters keySourceParameters() {
        return this.keySourceParameters;
    }

    /**
     * Set the keySourceParameters property: Defines the parameters for using customer key vault for Url Signing Key.
     * 
     * @param keySourceParameters the keySourceParameters value to set.
     * @return the UrlSigningKey object itself.
     */
    public UrlSigningKey withKeySourceParameters(KeyVaultSigningKeyParameters keySourceParameters) {
        this.keySourceParameters = keySourceParameters;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (keyId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property keyId in model UrlSigningKey"));
        }
        if (keySourceParameters() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property keySourceParameters in model UrlSigningKey"));
        } else {
            keySourceParameters().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(UrlSigningKey.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("keyId", this.keyId);
        jsonWriter.writeJsonField("keySourceParameters", this.keySourceParameters);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of UrlSigningKey from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of UrlSigningKey if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the UrlSigningKey.
     */
    public static UrlSigningKey fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            UrlSigningKey deserializedUrlSigningKey = new UrlSigningKey();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("keyId".equals(fieldName)) {
                    deserializedUrlSigningKey.keyId = reader.getString();
                } else if ("keySourceParameters".equals(fieldName)) {
                    deserializedUrlSigningKey.keySourceParameters = KeyVaultSigningKeyParameters.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedUrlSigningKey;
        });
    }
}
