// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The json object containing security policy waf parameters.
 */
@Fluent
public final class SecurityPolicyWebApplicationFirewallParameters extends SecurityPolicyPropertiesParameters {
    /*
     * The type of the Security policy to create.
     */
    private SecurityPolicyType type = SecurityPolicyType.WEB_APPLICATION_FIREWALL;

    /*
     * Resource ID.
     */
    private ResourceReference wafPolicy;

    /*
     * Waf associations
     */
    private List<SecurityPolicyWebApplicationFirewallAssociation> associations;

    /**
     * Creates an instance of SecurityPolicyWebApplicationFirewallParameters class.
     */
    public SecurityPolicyWebApplicationFirewallParameters() {
    }

    /**
     * Get the type property: The type of the Security policy to create.
     * 
     * @return the type value.
     */
    @Override
    public SecurityPolicyType type() {
        return this.type;
    }

    /**
     * Get the wafPolicy property: Resource ID.
     * 
     * @return the wafPolicy value.
     */
    public ResourceReference wafPolicy() {
        return this.wafPolicy;
    }

    /**
     * Set the wafPolicy property: Resource ID.
     * 
     * @param wafPolicy the wafPolicy value to set.
     * @return the SecurityPolicyWebApplicationFirewallParameters object itself.
     */
    public SecurityPolicyWebApplicationFirewallParameters withWafPolicy(ResourceReference wafPolicy) {
        this.wafPolicy = wafPolicy;
        return this;
    }

    /**
     * Get the associations property: Waf associations.
     * 
     * @return the associations value.
     */
    public List<SecurityPolicyWebApplicationFirewallAssociation> associations() {
        return this.associations;
    }

    /**
     * Set the associations property: Waf associations.
     * 
     * @param associations the associations value to set.
     * @return the SecurityPolicyWebApplicationFirewallParameters object itself.
     */
    public SecurityPolicyWebApplicationFirewallParameters
        withAssociations(List<SecurityPolicyWebApplicationFirewallAssociation> associations) {
        this.associations = associations;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (wafPolicy() != null) {
            wafPolicy().validate();
        }
        if (associations() != null) {
            associations().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeJsonField("wafPolicy", this.wafPolicy);
        jsonWriter.writeArrayField("associations", this.associations, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SecurityPolicyWebApplicationFirewallParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SecurityPolicyWebApplicationFirewallParameters if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SecurityPolicyWebApplicationFirewallParameters.
     */
    public static SecurityPolicyWebApplicationFirewallParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SecurityPolicyWebApplicationFirewallParameters deserializedSecurityPolicyWebApplicationFirewallParameters
                = new SecurityPolicyWebApplicationFirewallParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedSecurityPolicyWebApplicationFirewallParameters.type
                        = SecurityPolicyType.fromString(reader.getString());
                } else if ("wafPolicy".equals(fieldName)) {
                    deserializedSecurityPolicyWebApplicationFirewallParameters.wafPolicy
                        = ResourceReference.fromJson(reader);
                } else if ("associations".equals(fieldName)) {
                    List<SecurityPolicyWebApplicationFirewallAssociation> associations = reader
                        .readArray(reader1 -> SecurityPolicyWebApplicationFirewallAssociation.fromJson(reader1));
                    deserializedSecurityPolicyWebApplicationFirewallParameters.associations = associations;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSecurityPolicyWebApplicationFirewallParameters;
        });
    }
}
