// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Defines a rate limiting rule that can be included in a waf policy.
 */
@Fluent
public final class RateLimitRule extends CustomRule {
    /*
     * Defines rate limit threshold.
     */
    private int rateLimitThreshold;

    /*
     * Defines rate limit duration. Default is 1 minute.
     */
    private int rateLimitDurationInMinutes;

    /**
     * Creates an instance of RateLimitRule class.
     */
    public RateLimitRule() {
    }

    /**
     * Get the rateLimitThreshold property: Defines rate limit threshold.
     * 
     * @return the rateLimitThreshold value.
     */
    public int rateLimitThreshold() {
        return this.rateLimitThreshold;
    }

    /**
     * Set the rateLimitThreshold property: Defines rate limit threshold.
     * 
     * @param rateLimitThreshold the rateLimitThreshold value to set.
     * @return the RateLimitRule object itself.
     */
    public RateLimitRule withRateLimitThreshold(int rateLimitThreshold) {
        this.rateLimitThreshold = rateLimitThreshold;
        return this;
    }

    /**
     * Get the rateLimitDurationInMinutes property: Defines rate limit duration. Default is 1 minute.
     * 
     * @return the rateLimitDurationInMinutes value.
     */
    public int rateLimitDurationInMinutes() {
        return this.rateLimitDurationInMinutes;
    }

    /**
     * Set the rateLimitDurationInMinutes property: Defines rate limit duration. Default is 1 minute.
     * 
     * @param rateLimitDurationInMinutes the rateLimitDurationInMinutes value to set.
     * @return the RateLimitRule object itself.
     */
    public RateLimitRule withRateLimitDurationInMinutes(int rateLimitDurationInMinutes) {
        this.rateLimitDurationInMinutes = rateLimitDurationInMinutes;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RateLimitRule withName(String name) {
        super.withName(name);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RateLimitRule withEnabledState(CustomRuleEnabledState enabledState) {
        super.withEnabledState(enabledState);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RateLimitRule withPriority(int priority) {
        super.withPriority(priority);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RateLimitRule withMatchConditions(List<MatchCondition> matchConditions) {
        super.withMatchConditions(matchConditions);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RateLimitRule withAction(ActionType action) {
        super.withAction(action);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", name());
        jsonWriter.writeIntField("priority", priority());
        jsonWriter.writeArrayField("matchConditions", matchConditions(),
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("action", action() == null ? null : action().toString());
        jsonWriter.writeStringField("enabledState", enabledState() == null ? null : enabledState().toString());
        jsonWriter.writeIntField("rateLimitThreshold", this.rateLimitThreshold);
        jsonWriter.writeIntField("rateLimitDurationInMinutes", this.rateLimitDurationInMinutes);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RateLimitRule from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RateLimitRule if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RateLimitRule.
     */
    public static RateLimitRule fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RateLimitRule deserializedRateLimitRule = new RateLimitRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedRateLimitRule.withName(reader.getString());
                } else if ("priority".equals(fieldName)) {
                    deserializedRateLimitRule.withPriority(reader.getInt());
                } else if ("matchConditions".equals(fieldName)) {
                    List<MatchCondition> matchConditions
                        = reader.readArray(reader1 -> MatchCondition.fromJson(reader1));
                    deserializedRateLimitRule.withMatchConditions(matchConditions);
                } else if ("action".equals(fieldName)) {
                    deserializedRateLimitRule.withAction(ActionType.fromString(reader.getString()));
                } else if ("enabledState".equals(fieldName)) {
                    deserializedRateLimitRule.withEnabledState(CustomRuleEnabledState.fromString(reader.getString()));
                } else if ("rateLimitThreshold".equals(fieldName)) {
                    deserializedRateLimitRule.rateLimitThreshold = reader.getInt();
                } else if ("rateLimitDurationInMinutes".equals(fieldName)) {
                    deserializedRateLimitRule.rateLimitDurationInMinutes = reader.getInt();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRateLimitRule;
        });
    }
}
