// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.fluent.models.OriginInner;
import java.io.IOException;
import java.util.List;

/**
 * Result of the request to list origins. It contains a list of origin objects and a URL link to get the next set of
 * results.
 */
@Fluent
public final class OriginListResult implements JsonSerializable<OriginListResult> {
    /*
     * List of CDN origins within an endpoint
     */
    private List<OriginInner> value;

    /*
     * URL to get the next set of origin objects if there are any.
     */
    private String nextLink;

    /**
     * Creates an instance of OriginListResult class.
     */
    public OriginListResult() {
    }

    /**
     * Get the value property: List of CDN origins within an endpoint.
     * 
     * @return the value value.
     */
    public List<OriginInner> value() {
        return this.value;
    }

    /**
     * Get the nextLink property: URL to get the next set of origin objects if there are any.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: URL to get the next set of origin objects if there are any.
     * 
     * @param nextLink the nextLink value to set.
     * @return the OriginListResult object itself.
     */
    public OriginListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OriginListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of OriginListResult if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the OriginListResult.
     */
    public static OriginListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OriginListResult deserializedOriginListResult = new OriginListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<OriginInner> value = reader.readArray(reader1 -> OriginInner.fromJson(reader1));
                    deserializedOriginListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedOriginListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOriginListResult;
        });
    }
}
