// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Web Application Firewall Mapping.
 */
@Fluent
public final class MigrationWebApplicationFirewallMapping
    implements JsonSerializable<MigrationWebApplicationFirewallMapping> {
    /*
     * Migration From Waf policy
     */
    private ResourceReference migratedFrom;

    /*
     * Migration to Waf policy
     */
    private ResourceReference migratedTo;

    /**
     * Creates an instance of MigrationWebApplicationFirewallMapping class.
     */
    public MigrationWebApplicationFirewallMapping() {
    }

    /**
     * Get the migratedFrom property: Migration From Waf policy.
     * 
     * @return the migratedFrom value.
     */
    public ResourceReference migratedFrom() {
        return this.migratedFrom;
    }

    /**
     * Set the migratedFrom property: Migration From Waf policy.
     * 
     * @param migratedFrom the migratedFrom value to set.
     * @return the MigrationWebApplicationFirewallMapping object itself.
     */
    public MigrationWebApplicationFirewallMapping withMigratedFrom(ResourceReference migratedFrom) {
        this.migratedFrom = migratedFrom;
        return this;
    }

    /**
     * Get the migratedTo property: Migration to Waf policy.
     * 
     * @return the migratedTo value.
     */
    public ResourceReference migratedTo() {
        return this.migratedTo;
    }

    /**
     * Set the migratedTo property: Migration to Waf policy.
     * 
     * @param migratedTo the migratedTo value to set.
     * @return the MigrationWebApplicationFirewallMapping object itself.
     */
    public MigrationWebApplicationFirewallMapping withMigratedTo(ResourceReference migratedTo) {
        this.migratedTo = migratedTo;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (migratedFrom() != null) {
            migratedFrom().validate();
        }
        if (migratedTo() != null) {
            migratedTo().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("migratedFrom", this.migratedFrom);
        jsonWriter.writeJsonField("migratedTo", this.migratedTo);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MigrationWebApplicationFirewallMapping from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MigrationWebApplicationFirewallMapping if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MigrationWebApplicationFirewallMapping.
     */
    public static MigrationWebApplicationFirewallMapping fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MigrationWebApplicationFirewallMapping deserializedMigrationWebApplicationFirewallMapping
                = new MigrationWebApplicationFirewallMapping();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("migratedFrom".equals(fieldName)) {
                    deserializedMigrationWebApplicationFirewallMapping.migratedFrom
                        = ResourceReference.fromJson(reader);
                } else if ("migratedTo".equals(fieldName)) {
                    deserializedMigrationWebApplicationFirewallMapping.migratedTo = ResourceReference.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMigrationWebApplicationFirewallMapping;
        });
    }
}
