// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Defines the list of managed rule sets for the policy.
 */
@Fluent
public final class ManagedRuleSetList implements JsonSerializable<ManagedRuleSetList> {
    /*
     * List of rule sets.
     */
    private List<ManagedRuleSet> managedRuleSets;

    /**
     * Creates an instance of ManagedRuleSetList class.
     */
    public ManagedRuleSetList() {
    }

    /**
     * Get the managedRuleSets property: List of rule sets.
     * 
     * @return the managedRuleSets value.
     */
    public List<ManagedRuleSet> managedRuleSets() {
        return this.managedRuleSets;
    }

    /**
     * Set the managedRuleSets property: List of rule sets.
     * 
     * @param managedRuleSets the managedRuleSets value to set.
     * @return the ManagedRuleSetList object itself.
     */
    public ManagedRuleSetList withManagedRuleSets(List<ManagedRuleSet> managedRuleSets) {
        this.managedRuleSets = managedRuleSets;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (managedRuleSets() != null) {
            managedRuleSets().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("managedRuleSets", this.managedRuleSets,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedRuleSetList from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedRuleSetList if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ManagedRuleSetList.
     */
    public static ManagedRuleSetList fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedRuleSetList deserializedManagedRuleSetList = new ManagedRuleSetList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("managedRuleSets".equals(fieldName)) {
                    List<ManagedRuleSet> managedRuleSets
                        = reader.readArray(reader1 -> ManagedRuleSet.fromJson(reader1));
                    deserializedManagedRuleSetList.managedRuleSets = managedRuleSets;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedRuleSetList;
        });
    }
}
