// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Defines a managed rule group override setting.
 */
@Fluent
public final class ManagedRuleGroupOverride implements JsonSerializable<ManagedRuleGroupOverride> {
    /*
     * Describes the managed rule group within the rule set to override
     */
    private String ruleGroupName;

    /*
     * List of rules that will be enabled. If none specified, all rules in the group will be disabled.
     */
    private List<ManagedRuleOverride> rules;

    /**
     * Creates an instance of ManagedRuleGroupOverride class.
     */
    public ManagedRuleGroupOverride() {
    }

    /**
     * Get the ruleGroupName property: Describes the managed rule group within the rule set to override.
     * 
     * @return the ruleGroupName value.
     */
    public String ruleGroupName() {
        return this.ruleGroupName;
    }

    /**
     * Set the ruleGroupName property: Describes the managed rule group within the rule set to override.
     * 
     * @param ruleGroupName the ruleGroupName value to set.
     * @return the ManagedRuleGroupOverride object itself.
     */
    public ManagedRuleGroupOverride withRuleGroupName(String ruleGroupName) {
        this.ruleGroupName = ruleGroupName;
        return this;
    }

    /**
     * Get the rules property: List of rules that will be enabled. If none specified, all rules in the group will be
     * disabled.
     * 
     * @return the rules value.
     */
    public List<ManagedRuleOverride> rules() {
        return this.rules;
    }

    /**
     * Set the rules property: List of rules that will be enabled. If none specified, all rules in the group will be
     * disabled.
     * 
     * @param rules the rules value to set.
     * @return the ManagedRuleGroupOverride object itself.
     */
    public ManagedRuleGroupOverride withRules(List<ManagedRuleOverride> rules) {
        this.rules = rules;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (ruleGroupName() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property ruleGroupName in model ManagedRuleGroupOverride"));
        }
        if (rules() != null) {
            rules().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ManagedRuleGroupOverride.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("ruleGroupName", this.ruleGroupName);
        jsonWriter.writeArrayField("rules", this.rules, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedRuleGroupOverride from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedRuleGroupOverride if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ManagedRuleGroupOverride.
     */
    public static ManagedRuleGroupOverride fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedRuleGroupOverride deserializedManagedRuleGroupOverride = new ManagedRuleGroupOverride();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("ruleGroupName".equals(fieldName)) {
                    deserializedManagedRuleGroupOverride.ruleGroupName = reader.getString();
                } else if ("rules".equals(fieldName)) {
                    List<ManagedRuleOverride> rules
                        = reader.readArray(reader1 -> ManagedRuleOverride.fromJson(reader1));
                    deserializedManagedRuleGroupOverride.rules = rules;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedRuleGroupOverride;
        });
    }
}
