// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.ActivatedResourceReference;
import com.azure.resourcemanager.cdn.models.AfdEndpointProtocols;
import com.azure.resourcemanager.cdn.models.AfdRouteCacheConfiguration;
import com.azure.resourcemanager.cdn.models.EnabledState;
import com.azure.resourcemanager.cdn.models.ForwardingProtocol;
import com.azure.resourcemanager.cdn.models.HttpsRedirect;
import com.azure.resourcemanager.cdn.models.LinkToDefaultDomain;
import com.azure.resourcemanager.cdn.models.ResourceReference;
import java.io.IOException;
import java.util.List;

/**
 * The JSON object that contains the properties of the domain to create.
 */
@Fluent
public class RouteUpdatePropertiesParameters implements JsonSerializable<RouteUpdatePropertiesParameters> {
    /*
     * The name of the endpoint which holds the route.
     */
    private String endpointName;

    /*
     * Domains referenced by this endpoint.
     */
    private List<ActivatedResourceReference> customDomains;

    /*
     * A reference to the origin group.
     */
    private ResourceReference originGroup;

    /*
     * A directory path on the origin that AzureFrontDoor can use to retrieve content from, e.g.
     * contoso.cloudapp.net/originpath.
     */
    private String originPath;

    /*
     * rule sets referenced by this endpoint.
     */
    private List<ResourceReference> ruleSets;

    /*
     * List of supported protocols for this route.
     */
    private List<AfdEndpointProtocols> supportedProtocols;

    /*
     * The route patterns of the rule.
     */
    private List<String> patternsToMatch;

    /*
     * The caching configuration for this route. To disable caching, do not provide a cacheConfiguration object.
     */
    private AfdRouteCacheConfiguration cacheConfiguration;

    /*
     * Protocol this rule will use when forwarding traffic to backends.
     */
    private ForwardingProtocol forwardingProtocol;

    /*
     * whether this route will be linked to the default endpoint domain.
     */
    private LinkToDefaultDomain linkToDefaultDomain;

    /*
     * Whether to automatically redirect HTTP traffic to HTTPS traffic. Note that this is a easy way to set up this rule
     * and it will be the first rule that gets executed.
     */
    private HttpsRedirect httpsRedirect;

    /*
     * Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'
     */
    private EnabledState enabledState;

    /**
     * Creates an instance of RouteUpdatePropertiesParameters class.
     */
    public RouteUpdatePropertiesParameters() {
    }

    /**
     * Get the endpointName property: The name of the endpoint which holds the route.
     * 
     * @return the endpointName value.
     */
    public String endpointName() {
        return this.endpointName;
    }

    /**
     * Set the endpointName property: The name of the endpoint which holds the route.
     * 
     * @param endpointName the endpointName value to set.
     * @return the RouteUpdatePropertiesParameters object itself.
     */
    RouteUpdatePropertiesParameters withEndpointName(String endpointName) {
        this.endpointName = endpointName;
        return this;
    }

    /**
     * Get the customDomains property: Domains referenced by this endpoint.
     * 
     * @return the customDomains value.
     */
    public List<ActivatedResourceReference> customDomains() {
        return this.customDomains;
    }

    /**
     * Set the customDomains property: Domains referenced by this endpoint.
     * 
     * @param customDomains the customDomains value to set.
     * @return the RouteUpdatePropertiesParameters object itself.
     */
    public RouteUpdatePropertiesParameters withCustomDomains(List<ActivatedResourceReference> customDomains) {
        this.customDomains = customDomains;
        return this;
    }

    /**
     * Get the originGroup property: A reference to the origin group.
     * 
     * @return the originGroup value.
     */
    public ResourceReference originGroup() {
        return this.originGroup;
    }

    /**
     * Set the originGroup property: A reference to the origin group.
     * 
     * @param originGroup the originGroup value to set.
     * @return the RouteUpdatePropertiesParameters object itself.
     */
    public RouteUpdatePropertiesParameters withOriginGroup(ResourceReference originGroup) {
        this.originGroup = originGroup;
        return this;
    }

    /**
     * Get the originPath property: A directory path on the origin that AzureFrontDoor can use to retrieve content from,
     * e.g. contoso.cloudapp.net/originpath.
     * 
     * @return the originPath value.
     */
    public String originPath() {
        return this.originPath;
    }

    /**
     * Set the originPath property: A directory path on the origin that AzureFrontDoor can use to retrieve content from,
     * e.g. contoso.cloudapp.net/originpath.
     * 
     * @param originPath the originPath value to set.
     * @return the RouteUpdatePropertiesParameters object itself.
     */
    public RouteUpdatePropertiesParameters withOriginPath(String originPath) {
        this.originPath = originPath;
        return this;
    }

    /**
     * Get the ruleSets property: rule sets referenced by this endpoint.
     * 
     * @return the ruleSets value.
     */
    public List<ResourceReference> ruleSets() {
        return this.ruleSets;
    }

    /**
     * Set the ruleSets property: rule sets referenced by this endpoint.
     * 
     * @param ruleSets the ruleSets value to set.
     * @return the RouteUpdatePropertiesParameters object itself.
     */
    public RouteUpdatePropertiesParameters withRuleSets(List<ResourceReference> ruleSets) {
        this.ruleSets = ruleSets;
        return this;
    }

    /**
     * Get the supportedProtocols property: List of supported protocols for this route.
     * 
     * @return the supportedProtocols value.
     */
    public List<AfdEndpointProtocols> supportedProtocols() {
        return this.supportedProtocols;
    }

    /**
     * Set the supportedProtocols property: List of supported protocols for this route.
     * 
     * @param supportedProtocols the supportedProtocols value to set.
     * @return the RouteUpdatePropertiesParameters object itself.
     */
    public RouteUpdatePropertiesParameters withSupportedProtocols(List<AfdEndpointProtocols> supportedProtocols) {
        this.supportedProtocols = supportedProtocols;
        return this;
    }

    /**
     * Get the patternsToMatch property: The route patterns of the rule.
     * 
     * @return the patternsToMatch value.
     */
    public List<String> patternsToMatch() {
        return this.patternsToMatch;
    }

    /**
     * Set the patternsToMatch property: The route patterns of the rule.
     * 
     * @param patternsToMatch the patternsToMatch value to set.
     * @return the RouteUpdatePropertiesParameters object itself.
     */
    public RouteUpdatePropertiesParameters withPatternsToMatch(List<String> patternsToMatch) {
        this.patternsToMatch = patternsToMatch;
        return this;
    }

    /**
     * Get the cacheConfiguration property: The caching configuration for this route. To disable caching, do not provide
     * a cacheConfiguration object.
     * 
     * @return the cacheConfiguration value.
     */
    public AfdRouteCacheConfiguration cacheConfiguration() {
        return this.cacheConfiguration;
    }

    /**
     * Set the cacheConfiguration property: The caching configuration for this route. To disable caching, do not provide
     * a cacheConfiguration object.
     * 
     * @param cacheConfiguration the cacheConfiguration value to set.
     * @return the RouteUpdatePropertiesParameters object itself.
     */
    public RouteUpdatePropertiesParameters withCacheConfiguration(AfdRouteCacheConfiguration cacheConfiguration) {
        this.cacheConfiguration = cacheConfiguration;
        return this;
    }

    /**
     * Get the forwardingProtocol property: Protocol this rule will use when forwarding traffic to backends.
     * 
     * @return the forwardingProtocol value.
     */
    public ForwardingProtocol forwardingProtocol() {
        return this.forwardingProtocol;
    }

    /**
     * Set the forwardingProtocol property: Protocol this rule will use when forwarding traffic to backends.
     * 
     * @param forwardingProtocol the forwardingProtocol value to set.
     * @return the RouteUpdatePropertiesParameters object itself.
     */
    public RouteUpdatePropertiesParameters withForwardingProtocol(ForwardingProtocol forwardingProtocol) {
        this.forwardingProtocol = forwardingProtocol;
        return this;
    }

    /**
     * Get the linkToDefaultDomain property: whether this route will be linked to the default endpoint domain.
     * 
     * @return the linkToDefaultDomain value.
     */
    public LinkToDefaultDomain linkToDefaultDomain() {
        return this.linkToDefaultDomain;
    }

    /**
     * Set the linkToDefaultDomain property: whether this route will be linked to the default endpoint domain.
     * 
     * @param linkToDefaultDomain the linkToDefaultDomain value to set.
     * @return the RouteUpdatePropertiesParameters object itself.
     */
    public RouteUpdatePropertiesParameters withLinkToDefaultDomain(LinkToDefaultDomain linkToDefaultDomain) {
        this.linkToDefaultDomain = linkToDefaultDomain;
        return this;
    }

    /**
     * Get the httpsRedirect property: Whether to automatically redirect HTTP traffic to HTTPS traffic. Note that this
     * is a easy way to set up this rule and it will be the first rule that gets executed.
     * 
     * @return the httpsRedirect value.
     */
    public HttpsRedirect httpsRedirect() {
        return this.httpsRedirect;
    }

    /**
     * Set the httpsRedirect property: Whether to automatically redirect HTTP traffic to HTTPS traffic. Note that this
     * is a easy way to set up this rule and it will be the first rule that gets executed.
     * 
     * @param httpsRedirect the httpsRedirect value to set.
     * @return the RouteUpdatePropertiesParameters object itself.
     */
    public RouteUpdatePropertiesParameters withHttpsRedirect(HttpsRedirect httpsRedirect) {
        this.httpsRedirect = httpsRedirect;
        return this;
    }

    /**
     * Get the enabledState property: Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'.
     * 
     * @return the enabledState value.
     */
    public EnabledState enabledState() {
        return this.enabledState;
    }

    /**
     * Set the enabledState property: Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'.
     * 
     * @param enabledState the enabledState value to set.
     * @return the RouteUpdatePropertiesParameters object itself.
     */
    public RouteUpdatePropertiesParameters withEnabledState(EnabledState enabledState) {
        this.enabledState = enabledState;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (customDomains() != null) {
            customDomains().forEach(e -> e.validate());
        }
        if (originGroup() != null) {
            originGroup().validate();
        }
        if (ruleSets() != null) {
            ruleSets().forEach(e -> e.validate());
        }
        if (cacheConfiguration() != null) {
            cacheConfiguration().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("customDomains", this.customDomains, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("originGroup", this.originGroup);
        jsonWriter.writeStringField("originPath", this.originPath);
        jsonWriter.writeArrayField("ruleSets", this.ruleSets, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("supportedProtocols", this.supportedProtocols,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("patternsToMatch", this.patternsToMatch,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("cacheConfiguration", this.cacheConfiguration);
        jsonWriter.writeStringField("forwardingProtocol",
            this.forwardingProtocol == null ? null : this.forwardingProtocol.toString());
        jsonWriter.writeStringField("linkToDefaultDomain",
            this.linkToDefaultDomain == null ? null : this.linkToDefaultDomain.toString());
        jsonWriter.writeStringField("httpsRedirect", this.httpsRedirect == null ? null : this.httpsRedirect.toString());
        jsonWriter.writeStringField("enabledState", this.enabledState == null ? null : this.enabledState.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RouteUpdatePropertiesParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RouteUpdatePropertiesParameters if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RouteUpdatePropertiesParameters.
     */
    public static RouteUpdatePropertiesParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RouteUpdatePropertiesParameters deserializedRouteUpdatePropertiesParameters
                = new RouteUpdatePropertiesParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("endpointName".equals(fieldName)) {
                    deserializedRouteUpdatePropertiesParameters.endpointName = reader.getString();
                } else if ("customDomains".equals(fieldName)) {
                    List<ActivatedResourceReference> customDomains
                        = reader.readArray(reader1 -> ActivatedResourceReference.fromJson(reader1));
                    deserializedRouteUpdatePropertiesParameters.customDomains = customDomains;
                } else if ("originGroup".equals(fieldName)) {
                    deserializedRouteUpdatePropertiesParameters.originGroup = ResourceReference.fromJson(reader);
                } else if ("originPath".equals(fieldName)) {
                    deserializedRouteUpdatePropertiesParameters.originPath = reader.getString();
                } else if ("ruleSets".equals(fieldName)) {
                    List<ResourceReference> ruleSets = reader.readArray(reader1 -> ResourceReference.fromJson(reader1));
                    deserializedRouteUpdatePropertiesParameters.ruleSets = ruleSets;
                } else if ("supportedProtocols".equals(fieldName)) {
                    List<AfdEndpointProtocols> supportedProtocols
                        = reader.readArray(reader1 -> AfdEndpointProtocols.fromString(reader1.getString()));
                    deserializedRouteUpdatePropertiesParameters.supportedProtocols = supportedProtocols;
                } else if ("patternsToMatch".equals(fieldName)) {
                    List<String> patternsToMatch = reader.readArray(reader1 -> reader1.getString());
                    deserializedRouteUpdatePropertiesParameters.patternsToMatch = patternsToMatch;
                } else if ("cacheConfiguration".equals(fieldName)) {
                    deserializedRouteUpdatePropertiesParameters.cacheConfiguration
                        = AfdRouteCacheConfiguration.fromJson(reader);
                } else if ("forwardingProtocol".equals(fieldName)) {
                    deserializedRouteUpdatePropertiesParameters.forwardingProtocol
                        = ForwardingProtocol.fromString(reader.getString());
                } else if ("linkToDefaultDomain".equals(fieldName)) {
                    deserializedRouteUpdatePropertiesParameters.linkToDefaultDomain
                        = LinkToDefaultDomain.fromString(reader.getString());
                } else if ("httpsRedirect".equals(fieldName)) {
                    deserializedRouteUpdatePropertiesParameters.httpsRedirect
                        = HttpsRedirect.fromString(reader.getString());
                } else if ("enabledState".equals(fieldName)) {
                    deserializedRouteUpdatePropertiesParameters.enabledState
                        = EnabledState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRouteUpdatePropertiesParameters;
        });
    }
}
