// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.CanMigrateDefaultSku;
import com.azure.resourcemanager.cdn.models.MigrationErrorType;
import java.io.IOException;
import java.util.List;

/**
 * Result for canMigrate operation.
 */
@Fluent
public final class CanMigrateResultInner implements JsonSerializable<CanMigrateResultInner> {
    /*
     * Resource ID.
     */
    private String id;

    /*
     * Resource type.
     */
    private String type;

    /*
     * The properties property.
     */
    private CanMigrateProperties innerProperties;

    /**
     * Creates an instance of CanMigrateResultInner class.
     */
    public CanMigrateResultInner() {
    }

    /**
     * Get the id property: Resource ID.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the type property: Resource type.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Get the innerProperties property: The properties property.
     * 
     * @return the innerProperties value.
     */
    private CanMigrateProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the canMigrate property: Flag that says if the profile can be migrated.
     * 
     * @return the canMigrate value.
     */
    public Boolean canMigrate() {
        return this.innerProperties() == null ? null : this.innerProperties().canMigrate();
    }

    /**
     * Get the defaultSku property: Recommended sku for the migration.
     * 
     * @return the defaultSku value.
     */
    public CanMigrateDefaultSku defaultSku() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultSku();
    }

    /**
     * Get the errors property: The errors property.
     * 
     * @return the errors value.
     */
    public List<MigrationErrorType> errors() {
        return this.innerProperties() == null ? null : this.innerProperties().errors();
    }

    /**
     * Set the errors property: The errors property.
     * 
     * @param errors the errors value to set.
     * @return the CanMigrateResultInner object itself.
     */
    public CanMigrateResultInner withErrors(List<MigrationErrorType> errors) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CanMigrateProperties();
        }
        this.innerProperties().withErrors(errors);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CanMigrateResultInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CanMigrateResultInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CanMigrateResultInner.
     */
    public static CanMigrateResultInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CanMigrateResultInner deserializedCanMigrateResultInner = new CanMigrateResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedCanMigrateResultInner.id = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedCanMigrateResultInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedCanMigrateResultInner.innerProperties = CanMigrateProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCanMigrateResultInner;
        });
    }
}
