// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.EnabledState;
import com.azure.resourcemanager.cdn.models.HealthProbeParameters;
import com.azure.resourcemanager.cdn.models.LoadBalancingSettingsParameters;
import java.io.IOException;

/**
 * The JSON object that contains the properties of the origin group.
 */
@Fluent
public class AfdOriginGroupUpdatePropertiesParameters
    implements JsonSerializable<AfdOriginGroupUpdatePropertiesParameters> {
    /*
     * The name of the profile which holds the origin group.
     */
    private String profileName;

    /*
     * Load balancing settings for a backend pool
     */
    private LoadBalancingSettingsParameters loadBalancingSettings;

    /*
     * Health probe settings to the origin that is used to determine the health of the origin.
     */
    private HealthProbeParameters healthProbeSettings;

    /*
     * Time in minutes to shift the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new
     * endpoint is added. Default is 10 mins. This property is currently not supported.
     */
    private Integer trafficRestorationTimeToHealedOrNewEndpointsInMinutes;

    /*
     * Whether to allow session affinity on this host. Valid options are 'Enabled' or 'Disabled'
     */
    private EnabledState sessionAffinityState;

    /**
     * Creates an instance of AfdOriginGroupUpdatePropertiesParameters class.
     */
    public AfdOriginGroupUpdatePropertiesParameters() {
    }

    /**
     * Get the profileName property: The name of the profile which holds the origin group.
     * 
     * @return the profileName value.
     */
    public String profileName() {
        return this.profileName;
    }

    /**
     * Set the profileName property: The name of the profile which holds the origin group.
     * 
     * @param profileName the profileName value to set.
     * @return the AfdOriginGroupUpdatePropertiesParameters object itself.
     */
    AfdOriginGroupUpdatePropertiesParameters withProfileName(String profileName) {
        this.profileName = profileName;
        return this;
    }

    /**
     * Get the loadBalancingSettings property: Load balancing settings for a backend pool.
     * 
     * @return the loadBalancingSettings value.
     */
    public LoadBalancingSettingsParameters loadBalancingSettings() {
        return this.loadBalancingSettings;
    }

    /**
     * Set the loadBalancingSettings property: Load balancing settings for a backend pool.
     * 
     * @param loadBalancingSettings the loadBalancingSettings value to set.
     * @return the AfdOriginGroupUpdatePropertiesParameters object itself.
     */
    public AfdOriginGroupUpdatePropertiesParameters
        withLoadBalancingSettings(LoadBalancingSettingsParameters loadBalancingSettings) {
        this.loadBalancingSettings = loadBalancingSettings;
        return this;
    }

    /**
     * Get the healthProbeSettings property: Health probe settings to the origin that is used to determine the health of
     * the origin.
     * 
     * @return the healthProbeSettings value.
     */
    public HealthProbeParameters healthProbeSettings() {
        return this.healthProbeSettings;
    }

    /**
     * Set the healthProbeSettings property: Health probe settings to the origin that is used to determine the health of
     * the origin.
     * 
     * @param healthProbeSettings the healthProbeSettings value to set.
     * @return the AfdOriginGroupUpdatePropertiesParameters object itself.
     */
    public AfdOriginGroupUpdatePropertiesParameters withHealthProbeSettings(HealthProbeParameters healthProbeSettings) {
        this.healthProbeSettings = healthProbeSettings;
        return this;
    }

    /**
     * Get the trafficRestorationTimeToHealedOrNewEndpointsInMinutes property: Time in minutes to shift the traffic to
     * the endpoint gradually when an unhealthy endpoint comes healthy or a new endpoint is added. Default is 10 mins.
     * This property is currently not supported.
     * 
     * @return the trafficRestorationTimeToHealedOrNewEndpointsInMinutes value.
     */
    public Integer trafficRestorationTimeToHealedOrNewEndpointsInMinutes() {
        return this.trafficRestorationTimeToHealedOrNewEndpointsInMinutes;
    }

    /**
     * Set the trafficRestorationTimeToHealedOrNewEndpointsInMinutes property: Time in minutes to shift the traffic to
     * the endpoint gradually when an unhealthy endpoint comes healthy or a new endpoint is added. Default is 10 mins.
     * This property is currently not supported.
     * 
     * @param trafficRestorationTimeToHealedOrNewEndpointsInMinutes the
     * trafficRestorationTimeToHealedOrNewEndpointsInMinutes value to set.
     * @return the AfdOriginGroupUpdatePropertiesParameters object itself.
     */
    public AfdOriginGroupUpdatePropertiesParameters withTrafficRestorationTimeToHealedOrNewEndpointsInMinutes(
        Integer trafficRestorationTimeToHealedOrNewEndpointsInMinutes) {
        this.trafficRestorationTimeToHealedOrNewEndpointsInMinutes
            = trafficRestorationTimeToHealedOrNewEndpointsInMinutes;
        return this;
    }

    /**
     * Get the sessionAffinityState property: Whether to allow session affinity on this host. Valid options are
     * 'Enabled' or 'Disabled'.
     * 
     * @return the sessionAffinityState value.
     */
    public EnabledState sessionAffinityState() {
        return this.sessionAffinityState;
    }

    /**
     * Set the sessionAffinityState property: Whether to allow session affinity on this host. Valid options are
     * 'Enabled' or 'Disabled'.
     * 
     * @param sessionAffinityState the sessionAffinityState value to set.
     * @return the AfdOriginGroupUpdatePropertiesParameters object itself.
     */
    public AfdOriginGroupUpdatePropertiesParameters withSessionAffinityState(EnabledState sessionAffinityState) {
        this.sessionAffinityState = sessionAffinityState;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (loadBalancingSettings() != null) {
            loadBalancingSettings().validate();
        }
        if (healthProbeSettings() != null) {
            healthProbeSettings().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("loadBalancingSettings", this.loadBalancingSettings);
        jsonWriter.writeJsonField("healthProbeSettings", this.healthProbeSettings);
        jsonWriter.writeNumberField("trafficRestorationTimeToHealedOrNewEndpointsInMinutes",
            this.trafficRestorationTimeToHealedOrNewEndpointsInMinutes);
        jsonWriter.writeStringField("sessionAffinityState",
            this.sessionAffinityState == null ? null : this.sessionAffinityState.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AfdOriginGroupUpdatePropertiesParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AfdOriginGroupUpdatePropertiesParameters if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AfdOriginGroupUpdatePropertiesParameters.
     */
    public static AfdOriginGroupUpdatePropertiesParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AfdOriginGroupUpdatePropertiesParameters deserializedAfdOriginGroupUpdatePropertiesParameters
                = new AfdOriginGroupUpdatePropertiesParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("profileName".equals(fieldName)) {
                    deserializedAfdOriginGroupUpdatePropertiesParameters.profileName = reader.getString();
                } else if ("loadBalancingSettings".equals(fieldName)) {
                    deserializedAfdOriginGroupUpdatePropertiesParameters.loadBalancingSettings
                        = LoadBalancingSettingsParameters.fromJson(reader);
                } else if ("healthProbeSettings".equals(fieldName)) {
                    deserializedAfdOriginGroupUpdatePropertiesParameters.healthProbeSettings
                        = HealthProbeParameters.fromJson(reader);
                } else if ("trafficRestorationTimeToHealedOrNewEndpointsInMinutes".equals(fieldName)) {
                    deserializedAfdOriginGroupUpdatePropertiesParameters.trafficRestorationTimeToHealedOrNewEndpointsInMinutes
                        = reader.getNullable(JsonReader::getInt);
                } else if ("sessionAffinityState".equals(fieldName)) {
                    deserializedAfdOriginGroupUpdatePropertiesParameters.sessionAffinityState
                        = EnabledState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAfdOriginGroupUpdatePropertiesParameters;
        });
    }
}
