// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.AfdDomainHttpsParameters;
import com.azure.resourcemanager.cdn.models.ResourceReference;
import java.io.IOException;

/**
 * The JSON object that contains the properties of the domain to create.
 */
@Fluent
public class AfdDomainUpdatePropertiesParameters implements JsonSerializable<AfdDomainUpdatePropertiesParameters> {
    /*
     * The name of the profile which holds the domain.
     */
    private String profileName;

    /*
     * The configuration specifying how to enable HTTPS for the domain - using AzureFrontDoor managed certificate or
     * user's own certificate. If not specified, enabling ssl uses AzureFrontDoor managed certificate by default.
     */
    private AfdDomainHttpsParameters tlsSettings;

    /*
     * Resource reference to the Azure DNS zone
     */
    private ResourceReference azureDnsZone;

    /*
     * Resource reference to the Azure resource where custom domain ownership was prevalidated
     */
    private ResourceReference preValidatedCustomDomainResourceId;

    /**
     * Creates an instance of AfdDomainUpdatePropertiesParameters class.
     */
    public AfdDomainUpdatePropertiesParameters() {
    }

    /**
     * Get the profileName property: The name of the profile which holds the domain.
     * 
     * @return the profileName value.
     */
    public String profileName() {
        return this.profileName;
    }

    /**
     * Set the profileName property: The name of the profile which holds the domain.
     * 
     * @param profileName the profileName value to set.
     * @return the AfdDomainUpdatePropertiesParameters object itself.
     */
    AfdDomainUpdatePropertiesParameters withProfileName(String profileName) {
        this.profileName = profileName;
        return this;
    }

    /**
     * Get the tlsSettings property: The configuration specifying how to enable HTTPS for the domain - using
     * AzureFrontDoor managed certificate or user's own certificate. If not specified, enabling ssl uses AzureFrontDoor
     * managed certificate by default.
     * 
     * @return the tlsSettings value.
     */
    public AfdDomainHttpsParameters tlsSettings() {
        return this.tlsSettings;
    }

    /**
     * Set the tlsSettings property: The configuration specifying how to enable HTTPS for the domain - using
     * AzureFrontDoor managed certificate or user's own certificate. If not specified, enabling ssl uses AzureFrontDoor
     * managed certificate by default.
     * 
     * @param tlsSettings the tlsSettings value to set.
     * @return the AfdDomainUpdatePropertiesParameters object itself.
     */
    public AfdDomainUpdatePropertiesParameters withTlsSettings(AfdDomainHttpsParameters tlsSettings) {
        this.tlsSettings = tlsSettings;
        return this;
    }

    /**
     * Get the azureDnsZone property: Resource reference to the Azure DNS zone.
     * 
     * @return the azureDnsZone value.
     */
    public ResourceReference azureDnsZone() {
        return this.azureDnsZone;
    }

    /**
     * Set the azureDnsZone property: Resource reference to the Azure DNS zone.
     * 
     * @param azureDnsZone the azureDnsZone value to set.
     * @return the AfdDomainUpdatePropertiesParameters object itself.
     */
    public AfdDomainUpdatePropertiesParameters withAzureDnsZone(ResourceReference azureDnsZone) {
        this.azureDnsZone = azureDnsZone;
        return this;
    }

    /**
     * Get the preValidatedCustomDomainResourceId property: Resource reference to the Azure resource where custom domain
     * ownership was prevalidated.
     * 
     * @return the preValidatedCustomDomainResourceId value.
     */
    public ResourceReference preValidatedCustomDomainResourceId() {
        return this.preValidatedCustomDomainResourceId;
    }

    /**
     * Set the preValidatedCustomDomainResourceId property: Resource reference to the Azure resource where custom domain
     * ownership was prevalidated.
     * 
     * @param preValidatedCustomDomainResourceId the preValidatedCustomDomainResourceId value to set.
     * @return the AfdDomainUpdatePropertiesParameters object itself.
     */
    public AfdDomainUpdatePropertiesParameters
        withPreValidatedCustomDomainResourceId(ResourceReference preValidatedCustomDomainResourceId) {
        this.preValidatedCustomDomainResourceId = preValidatedCustomDomainResourceId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (tlsSettings() != null) {
            tlsSettings().validate();
        }
        if (azureDnsZone() != null) {
            azureDnsZone().validate();
        }
        if (preValidatedCustomDomainResourceId() != null) {
            preValidatedCustomDomainResourceId().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("tlsSettings", this.tlsSettings);
        jsonWriter.writeJsonField("azureDnsZone", this.azureDnsZone);
        jsonWriter.writeJsonField("preValidatedCustomDomainResourceId", this.preValidatedCustomDomainResourceId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AfdDomainUpdatePropertiesParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AfdDomainUpdatePropertiesParameters if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AfdDomainUpdatePropertiesParameters.
     */
    public static AfdDomainUpdatePropertiesParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AfdDomainUpdatePropertiesParameters deserializedAfdDomainUpdatePropertiesParameters
                = new AfdDomainUpdatePropertiesParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("profileName".equals(fieldName)) {
                    deserializedAfdDomainUpdatePropertiesParameters.profileName = reader.getString();
                } else if ("tlsSettings".equals(fieldName)) {
                    deserializedAfdDomainUpdatePropertiesParameters.tlsSettings
                        = AfdDomainHttpsParameters.fromJson(reader);
                } else if ("azureDnsZone".equals(fieldName)) {
                    deserializedAfdDomainUpdatePropertiesParameters.azureDnsZone = ResourceReference.fromJson(reader);
                } else if ("preValidatedCustomDomainResourceId".equals(fieldName)) {
                    deserializedAfdDomainUpdatePropertiesParameters.preValidatedCustomDomainResourceId
                        = ResourceReference.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAfdDomainUpdatePropertiesParameters;
        });
    }
}
