/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.HealthProbeRequestType;
import com.azure.resourcemanager.cdn.models.ProbeProtocol;
import java.io.IOException;

public final class HealthProbeParameters
implements JsonSerializable<HealthProbeParameters> {
    private String probePath;
    private HealthProbeRequestType probeRequestType;
    private ProbeProtocol probeProtocol;
    private Integer probeIntervalInSeconds;

    public String probePath() {
        return this.probePath;
    }

    public HealthProbeParameters withProbePath(String probePath) {
        this.probePath = probePath;
        return this;
    }

    public HealthProbeRequestType probeRequestType() {
        return this.probeRequestType;
    }

    public HealthProbeParameters withProbeRequestType(HealthProbeRequestType probeRequestType) {
        this.probeRequestType = probeRequestType;
        return this;
    }

    public ProbeProtocol probeProtocol() {
        return this.probeProtocol;
    }

    public HealthProbeParameters withProbeProtocol(ProbeProtocol probeProtocol) {
        this.probeProtocol = probeProtocol;
        return this;
    }

    public Integer probeIntervalInSeconds() {
        return this.probeIntervalInSeconds;
    }

    public HealthProbeParameters withProbeIntervalInSeconds(Integer probeIntervalInSeconds) {
        this.probeIntervalInSeconds = probeIntervalInSeconds;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("probePath", this.probePath);
        jsonWriter.writeStringField("probeRequestType", this.probeRequestType == null ? null : this.probeRequestType.toString());
        jsonWriter.writeStringField("probeProtocol", this.probeProtocol == null ? null : this.probeProtocol.toString());
        jsonWriter.writeNumberField("probeIntervalInSeconds", (Number)this.probeIntervalInSeconds);
        return jsonWriter.writeEndObject();
    }

    public static HealthProbeParameters fromJson(JsonReader jsonReader) throws IOException {
        return (HealthProbeParameters)jsonReader.readObject(reader -> {
            HealthProbeParameters deserializedHealthProbeParameters = new HealthProbeParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("probePath".equals(fieldName)) {
                    deserializedHealthProbeParameters.probePath = reader.getString();
                    continue;
                }
                if ("probeRequestType".equals(fieldName)) {
                    deserializedHealthProbeParameters.probeRequestType = HealthProbeRequestType.fromString(reader.getString());
                    continue;
                }
                if ("probeProtocol".equals(fieldName)) {
                    deserializedHealthProbeParameters.probeProtocol = ProbeProtocol.fromString(reader.getString());
                    continue;
                }
                if ("probeIntervalInSeconds".equals(fieldName)) {
                    deserializedHealthProbeParameters.probeIntervalInSeconds = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHealthProbeParameters;
        });
    }
}

