/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.ClientPortMatchConditionParameters;
import com.azure.resourcemanager.cdn.models.DeliveryRuleCondition;
import com.azure.resourcemanager.cdn.models.MatchVariable;
import java.io.IOException;

public final class DeliveryRuleClientPortCondition
extends DeliveryRuleCondition {
    private MatchVariable name = MatchVariable.CLIENT_PORT;
    private ClientPortMatchConditionParameters parameters;
    private static final ClientLogger LOGGER = new ClientLogger(DeliveryRuleClientPortCondition.class);

    @Override
    public MatchVariable name() {
        return this.name;
    }

    public ClientPortMatchConditionParameters parameters() {
        return this.parameters;
    }

    public DeliveryRuleClientPortCondition withParameters(ClientPortMatchConditionParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.parameters() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property parameters in model DeliveryRuleClientPortCondition"));
        }
        this.parameters().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("parameters", (JsonSerializable)this.parameters);
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        return jsonWriter.writeEndObject();
    }

    public static DeliveryRuleClientPortCondition fromJson(JsonReader jsonReader) throws IOException {
        return (DeliveryRuleClientPortCondition)jsonReader.readObject(reader -> {
            DeliveryRuleClientPortCondition deserializedDeliveryRuleClientPortCondition = new DeliveryRuleClientPortCondition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("parameters".equals(fieldName)) {
                    deserializedDeliveryRuleClientPortCondition.parameters = ClientPortMatchConditionParameters.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDeliveryRuleClientPortCondition.name = MatchVariable.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeliveryRuleClientPortCondition;
        });
    }
}

