/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.AfdProvisioningState;
import com.azure.resourcemanager.cdn.models.AfdStateProperties;
import com.azure.resourcemanager.cdn.models.DeploymentStatus;
import com.azure.resourcemanager.cdn.models.SecurityPolicyPropertiesParameters;
import java.io.IOException;

public final class SecurityPolicyProperties
extends AfdStateProperties {
    private String profileName;
    private SecurityPolicyPropertiesParameters parameters;
    private DeploymentStatus deploymentStatus;
    private AfdProvisioningState provisioningState;

    public String profileName() {
        return this.profileName;
    }

    public SecurityPolicyPropertiesParameters parameters() {
        return this.parameters;
    }

    public SecurityPolicyProperties withParameters(SecurityPolicyPropertiesParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    @Override
    public DeploymentStatus deploymentStatus() {
        return this.deploymentStatus;
    }

    @Override
    public AfdProvisioningState provisioningState() {
        return this.provisioningState;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.parameters() != null) {
            this.parameters().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("parameters", (JsonSerializable)this.parameters);
        return jsonWriter.writeEndObject();
    }

    public static SecurityPolicyProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SecurityPolicyProperties)jsonReader.readObject(reader -> {
            SecurityPolicyProperties deserializedSecurityPolicyProperties = new SecurityPolicyProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedSecurityPolicyProperties.provisioningState = AfdProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("deploymentStatus".equals(fieldName)) {
                    deserializedSecurityPolicyProperties.deploymentStatus = DeploymentStatus.fromString(reader.getString());
                    continue;
                }
                if ("profileName".equals(fieldName)) {
                    deserializedSecurityPolicyProperties.profileName = reader.getString();
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    deserializedSecurityPolicyProperties.parameters = SecurityPolicyPropertiesParameters.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSecurityPolicyProperties;
        });
    }
}

