/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.fluent.models.RuleUpdatePropertiesParameters;
import com.azure.resourcemanager.cdn.models.AfdProvisioningState;
import com.azure.resourcemanager.cdn.models.DeliveryRuleAction;
import com.azure.resourcemanager.cdn.models.DeliveryRuleCondition;
import com.azure.resourcemanager.cdn.models.DeploymentStatus;
import com.azure.resourcemanager.cdn.models.MatchProcessingBehavior;
import java.io.IOException;
import java.util.List;

public final class RuleProperties
extends RuleUpdatePropertiesParameters {
    private AfdProvisioningState provisioningState;
    private DeploymentStatus deploymentStatus;
    private String ruleSetName;

    public AfdProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public DeploymentStatus deploymentStatus() {
        return this.deploymentStatus;
    }

    @Override
    public String ruleSetName() {
        return this.ruleSetName;
    }

    @Override
    public RuleProperties withOrder(Integer order) {
        super.withOrder(order);
        return this;
    }

    @Override
    public RuleProperties withConditions(List<DeliveryRuleCondition> conditions) {
        super.withConditions(conditions);
        return this;
    }

    @Override
    public RuleProperties withActions(List<DeliveryRuleAction> actions) {
        super.withActions(actions);
        return this;
    }

    @Override
    public RuleProperties withMatchProcessingBehavior(MatchProcessingBehavior matchProcessingBehavior) {
        super.withMatchProcessingBehavior(matchProcessingBehavior);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("order", (Number)this.order());
        jsonWriter.writeArrayField("conditions", this.conditions(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("actions", this.actions(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("matchProcessingBehavior", this.matchProcessingBehavior() == null ? null : this.matchProcessingBehavior().toString());
        return jsonWriter.writeEndObject();
    }

    public static RuleProperties fromJson(JsonReader jsonReader) throws IOException {
        return (RuleProperties)jsonReader.readObject(reader -> {
            RuleProperties deserializedRuleProperties = new RuleProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("ruleSetName".equals(fieldName)) {
                    deserializedRuleProperties.ruleSetName = reader.getString();
                    continue;
                }
                if ("order".equals(fieldName)) {
                    deserializedRuleProperties.withOrder((Integer)reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("conditions".equals(fieldName)) {
                    List conditions = reader.readArray(reader1 -> DeliveryRuleCondition.fromJson(reader1));
                    deserializedRuleProperties.withConditions(conditions);
                    continue;
                }
                if ("actions".equals(fieldName)) {
                    List actions = reader.readArray(reader1 -> DeliveryRuleAction.fromJson(reader1));
                    deserializedRuleProperties.withActions(actions);
                    continue;
                }
                if ("matchProcessingBehavior".equals(fieldName)) {
                    deserializedRuleProperties.withMatchProcessingBehavior(MatchProcessingBehavior.fromString(reader.getString()));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedRuleProperties.provisioningState = AfdProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("deploymentStatus".equals(fieldName)) {
                    deserializedRuleProperties.deploymentStatus = DeploymentStatus.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRuleProperties;
        });
    }
}

