/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.fluent.models.RuleProperties;
import com.azure.resourcemanager.cdn.models.AfdProvisioningState;
import com.azure.resourcemanager.cdn.models.DeliveryRuleAction;
import com.azure.resourcemanager.cdn.models.DeliveryRuleCondition;
import com.azure.resourcemanager.cdn.models.DeploymentStatus;
import com.azure.resourcemanager.cdn.models.MatchProcessingBehavior;
import java.io.IOException;
import java.util.List;

public final class RuleInner
extends ProxyResource {
    private RuleProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private RuleProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public AfdProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public DeploymentStatus deploymentStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().deploymentStatus();
    }

    public String ruleSetName() {
        return this.innerProperties() == null ? null : this.innerProperties().ruleSetName();
    }

    public Integer order() {
        return this.innerProperties() == null ? null : this.innerProperties().order();
    }

    public RuleInner withOrder(Integer order) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RuleProperties();
        }
        this.innerProperties().withOrder(order);
        return this;
    }

    public List<DeliveryRuleCondition> conditions() {
        return this.innerProperties() == null ? null : this.innerProperties().conditions();
    }

    public RuleInner withConditions(List<DeliveryRuleCondition> conditions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RuleProperties();
        }
        this.innerProperties().withConditions((List)conditions);
        return this;
    }

    public List<DeliveryRuleAction> actions() {
        return this.innerProperties() == null ? null : this.innerProperties().actions();
    }

    public RuleInner withActions(List<DeliveryRuleAction> actions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RuleProperties();
        }
        this.innerProperties().withActions((List)actions);
        return this;
    }

    public MatchProcessingBehavior matchProcessingBehavior() {
        return this.innerProperties() == null ? null : this.innerProperties().matchProcessingBehavior();
    }

    public RuleInner withMatchProcessingBehavior(MatchProcessingBehavior matchProcessingBehavior) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RuleProperties();
        }
        this.innerProperties().withMatchProcessingBehavior(matchProcessingBehavior);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static RuleInner fromJson(JsonReader jsonReader) throws IOException {
        return (RuleInner)((Object)jsonReader.readObject(reader -> {
            RuleInner deserializedRuleInner = new RuleInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedRuleInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedRuleInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedRuleInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedRuleInner.innerProperties = RuleProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedRuleInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRuleInner;
        }));
    }
}

