/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.fluent.models.AfdOriginUpdatePropertiesParameters;
import com.azure.resourcemanager.cdn.models.AfdProvisioningState;
import com.azure.resourcemanager.cdn.models.DeploymentStatus;
import com.azure.resourcemanager.cdn.models.EnabledState;
import com.azure.resourcemanager.cdn.models.ResourceReference;
import com.azure.resourcemanager.cdn.models.SharedPrivateLinkResourceProperties;
import java.io.IOException;

public final class AfdOriginProperties
extends AfdOriginUpdatePropertiesParameters {
    private AfdProvisioningState provisioningState;
    private DeploymentStatus deploymentStatus;
    private String originGroupName;

    public AfdProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public DeploymentStatus deploymentStatus() {
        return this.deploymentStatus;
    }

    @Override
    public String originGroupName() {
        return this.originGroupName;
    }

    @Override
    public AfdOriginProperties withAzureOrigin(ResourceReference azureOrigin) {
        super.withAzureOrigin(azureOrigin);
        return this;
    }

    @Override
    public AfdOriginProperties withHostname(String hostname) {
        super.withHostname(hostname);
        return this;
    }

    @Override
    public AfdOriginProperties withHttpPort(Integer httpPort) {
        super.withHttpPort(httpPort);
        return this;
    }

    @Override
    public AfdOriginProperties withHttpsPort(Integer httpsPort) {
        super.withHttpsPort(httpsPort);
        return this;
    }

    @Override
    public AfdOriginProperties withOriginHostHeader(String originHostHeader) {
        super.withOriginHostHeader(originHostHeader);
        return this;
    }

    @Override
    public AfdOriginProperties withPriority(Integer priority) {
        super.withPriority(priority);
        return this;
    }

    @Override
    public AfdOriginProperties withWeight(Integer weight) {
        super.withWeight(weight);
        return this;
    }

    @Override
    public AfdOriginProperties withSharedPrivateLinkResource(SharedPrivateLinkResourceProperties sharedPrivateLinkResource) {
        super.withSharedPrivateLinkResource(sharedPrivateLinkResource);
        return this;
    }

    @Override
    public AfdOriginProperties withEnabledState(EnabledState enabledState) {
        super.withEnabledState(enabledState);
        return this;
    }

    @Override
    public AfdOriginProperties withEnforceCertificateNameCheck(Boolean enforceCertificateNameCheck) {
        super.withEnforceCertificateNameCheck(enforceCertificateNameCheck);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("azureOrigin", (JsonSerializable)this.azureOrigin());
        jsonWriter.writeStringField("hostName", this.hostname());
        jsonWriter.writeNumberField("httpPort", (Number)this.httpPort());
        jsonWriter.writeNumberField("httpsPort", (Number)this.httpsPort());
        jsonWriter.writeStringField("originHostHeader", this.originHostHeader());
        jsonWriter.writeNumberField("priority", (Number)this.priority());
        jsonWriter.writeNumberField("weight", (Number)this.weight());
        jsonWriter.writeJsonField("sharedPrivateLinkResource", (JsonSerializable)this.sharedPrivateLinkResource());
        jsonWriter.writeStringField("enabledState", this.enabledState() == null ? null : this.enabledState().toString());
        jsonWriter.writeBooleanField("enforceCertificateNameCheck", this.enforceCertificateNameCheck());
        return jsonWriter.writeEndObject();
    }

    public static AfdOriginProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AfdOriginProperties)jsonReader.readObject(reader -> {
            AfdOriginProperties deserializedAfdOriginProperties = new AfdOriginProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("originGroupName".equals(fieldName)) {
                    deserializedAfdOriginProperties.originGroupName = reader.getString();
                    continue;
                }
                if ("azureOrigin".equals(fieldName)) {
                    deserializedAfdOriginProperties.withAzureOrigin(ResourceReference.fromJson(reader));
                    continue;
                }
                if ("hostName".equals(fieldName)) {
                    deserializedAfdOriginProperties.withHostname(reader.getString());
                    continue;
                }
                if ("httpPort".equals(fieldName)) {
                    deserializedAfdOriginProperties.withHttpPort((Integer)reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("httpsPort".equals(fieldName)) {
                    deserializedAfdOriginProperties.withHttpsPort((Integer)reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("originHostHeader".equals(fieldName)) {
                    deserializedAfdOriginProperties.withOriginHostHeader(reader.getString());
                    continue;
                }
                if ("priority".equals(fieldName)) {
                    deserializedAfdOriginProperties.withPriority((Integer)reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("weight".equals(fieldName)) {
                    deserializedAfdOriginProperties.withWeight((Integer)reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("sharedPrivateLinkResource".equals(fieldName)) {
                    deserializedAfdOriginProperties.withSharedPrivateLinkResource(SharedPrivateLinkResourceProperties.fromJson(reader));
                    continue;
                }
                if ("enabledState".equals(fieldName)) {
                    deserializedAfdOriginProperties.withEnabledState(EnabledState.fromString(reader.getString()));
                    continue;
                }
                if ("enforceCertificateNameCheck".equals(fieldName)) {
                    deserializedAfdOriginProperties.withEnforceCertificateNameCheck((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedAfdOriginProperties.provisioningState = AfdProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("deploymentStatus".equals(fieldName)) {
                    deserializedAfdOriginProperties.deploymentStatus = DeploymentStatus.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAfdOriginProperties;
        });
    }
}

