// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Url signing key parameters.
 */
@Fluent
public final class UrlSigningKeyParameters extends SecretParameters {
    /*
     * The type of the secret resource.
     */
    private SecretType type = SecretType.URL_SIGNING_KEY;

    /*
     * Defines the customer defined key Id. This id will exist in the incoming request to indicate the key used to form
     * the hash.
     */
    private String keyId;

    /*
     * Resource reference to the Azure Key Vault secret. Expected to be in format of
     * /subscriptions/{​​​​​​​​​subscriptionId}​​​​​​​​​/resourceGroups/{​​​​​​​​​resourceGroupName}
     * ​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/providers/Microsoft.KeyVault/vaults/{vaultName}
     * ​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/secrets/{secretName}
     * ​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​
     */
    private ResourceReference secretSource;

    /*
     * Version of the secret to be used
     */
    private String secretVersion;

    /**
     * Creates an instance of UrlSigningKeyParameters class.
     */
    public UrlSigningKeyParameters() {
    }

    /**
     * Get the type property: The type of the secret resource.
     * 
     * @return the type value.
     */
    @Override
    public SecretType type() {
        return this.type;
    }

    /**
     * Get the keyId property: Defines the customer defined key Id. This id will exist in the incoming request to
     * indicate the key used to form the hash.
     * 
     * @return the keyId value.
     */
    public String keyId() {
        return this.keyId;
    }

    /**
     * Set the keyId property: Defines the customer defined key Id. This id will exist in the incoming request to
     * indicate the key used to form the hash.
     * 
     * @param keyId the keyId value to set.
     * @return the UrlSigningKeyParameters object itself.
     */
    public UrlSigningKeyParameters withKeyId(String keyId) {
        this.keyId = keyId;
        return this;
    }

    /**
     * Get the secretSource property: Resource reference to the Azure Key Vault secret. Expected to be in format of
     * /subscriptions/{​​​​​​​​​subscriptionId}​​​​​​​​​/resourceGroups/{​​​​​​​​​resourceGroupName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/providers/Microsoft.KeyVault/vaults/{vaultName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/secrets/{secretName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​.
     * 
     * @return the secretSource value.
     */
    public ResourceReference secretSource() {
        return this.secretSource;
    }

    /**
     * Set the secretSource property: Resource reference to the Azure Key Vault secret. Expected to be in format of
     * /subscriptions/{​​​​​​​​​subscriptionId}​​​​​​​​​/resourceGroups/{​​​​​​​​​resourceGroupName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/providers/Microsoft.KeyVault/vaults/{vaultName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/secrets/{secretName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​.
     * 
     * @param secretSource the secretSource value to set.
     * @return the UrlSigningKeyParameters object itself.
     */
    public UrlSigningKeyParameters withSecretSource(ResourceReference secretSource) {
        this.secretSource = secretSource;
        return this;
    }

    /**
     * Get the secretVersion property: Version of the secret to be used.
     * 
     * @return the secretVersion value.
     */
    public String secretVersion() {
        return this.secretVersion;
    }

    /**
     * Set the secretVersion property: Version of the secret to be used.
     * 
     * @param secretVersion the secretVersion value to set.
     * @return the UrlSigningKeyParameters object itself.
     */
    public UrlSigningKeyParameters withSecretVersion(String secretVersion) {
        this.secretVersion = secretVersion;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (keyId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property keyId in model UrlSigningKeyParameters"));
        }
        if (secretSource() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property secretSource in model UrlSigningKeyParameters"));
        } else {
            secretSource().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(UrlSigningKeyParameters.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("keyId", this.keyId);
        jsonWriter.writeJsonField("secretSource", this.secretSource);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("secretVersion", this.secretVersion);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of UrlSigningKeyParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of UrlSigningKeyParameters if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the UrlSigningKeyParameters.
     */
    public static UrlSigningKeyParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            UrlSigningKeyParameters deserializedUrlSigningKeyParameters = new UrlSigningKeyParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("keyId".equals(fieldName)) {
                    deserializedUrlSigningKeyParameters.keyId = reader.getString();
                } else if ("secretSource".equals(fieldName)) {
                    deserializedUrlSigningKeyParameters.secretSource = ResourceReference.fromJson(reader);
                } else if ("type".equals(fieldName)) {
                    deserializedUrlSigningKeyParameters.type = SecretType.fromString(reader.getString());
                } else if ("secretVersion".equals(fieldName)) {
                    deserializedUrlSigningKeyParameters.secretVersion = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedUrlSigningKeyParameters;
        });
    }
}
