// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Defines the parameters for the cache-key query string action.
 */
@Fluent
public final class CacheKeyQueryStringActionParameters
    implements JsonSerializable<CacheKeyQueryStringActionParameters> {
    /*
     * The typeName property.
     */
    private String typeName = "DeliveryRuleCacheKeyQueryStringBehaviorActionParameters";

    /*
     * Caching behavior for the requests
     */
    private QueryStringBehavior queryStringBehavior;

    /*
     * query parameters to include or exclude (comma separated).
     */
    private String queryParameters;

    /**
     * Creates an instance of CacheKeyQueryStringActionParameters class.
     */
    public CacheKeyQueryStringActionParameters() {
    }

    /**
     * Get the typeName property: The typeName property.
     * 
     * @return the typeName value.
     */
    public String typeName() {
        return this.typeName;
    }

    /**
     * Set the typeName property: The typeName property.
     * 
     * @param typeName the typeName value to set.
     * @return the CacheKeyQueryStringActionParameters object itself.
     */
    public CacheKeyQueryStringActionParameters withTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    /**
     * Get the queryStringBehavior property: Caching behavior for the requests.
     * 
     * @return the queryStringBehavior value.
     */
    public QueryStringBehavior queryStringBehavior() {
        return this.queryStringBehavior;
    }

    /**
     * Set the queryStringBehavior property: Caching behavior for the requests.
     * 
     * @param queryStringBehavior the queryStringBehavior value to set.
     * @return the CacheKeyQueryStringActionParameters object itself.
     */
    public CacheKeyQueryStringActionParameters withQueryStringBehavior(QueryStringBehavior queryStringBehavior) {
        this.queryStringBehavior = queryStringBehavior;
        return this;
    }

    /**
     * Get the queryParameters property: query parameters to include or exclude (comma separated).
     * 
     * @return the queryParameters value.
     */
    public String queryParameters() {
        return this.queryParameters;
    }

    /**
     * Set the queryParameters property: query parameters to include or exclude (comma separated).
     * 
     * @param queryParameters the queryParameters value to set.
     * @return the CacheKeyQueryStringActionParameters object itself.
     */
    public CacheKeyQueryStringActionParameters withQueryParameters(String queryParameters) {
        this.queryParameters = queryParameters;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (queryStringBehavior() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property queryStringBehavior in model CacheKeyQueryStringActionParameters"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(CacheKeyQueryStringActionParameters.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("typeName", this.typeName);
        jsonWriter.writeStringField("queryStringBehavior",
            this.queryStringBehavior == null ? null : this.queryStringBehavior.toString());
        jsonWriter.writeStringField("queryParameters", this.queryParameters);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CacheKeyQueryStringActionParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CacheKeyQueryStringActionParameters if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the CacheKeyQueryStringActionParameters.
     */
    public static CacheKeyQueryStringActionParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CacheKeyQueryStringActionParameters deserializedCacheKeyQueryStringActionParameters
                = new CacheKeyQueryStringActionParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("queryStringBehavior".equals(fieldName)) {
                    deserializedCacheKeyQueryStringActionParameters.queryStringBehavior
                        = QueryStringBehavior.fromString(reader.getString());
                } else if ("queryParameters".equals(fieldName)) {
                    deserializedCacheKeyQueryStringActionParameters.queryParameters = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCacheKeyQueryStringActionParameters;
        });
    }
}
