/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.ResourceReference;
import java.io.IOException;

public final class ProfileChangeSkuWafMapping
implements JsonSerializable<ProfileChangeSkuWafMapping> {
    private String securityPolicyName;
    private ResourceReference changeToWafPolicy;
    private static final ClientLogger LOGGER = new ClientLogger(ProfileChangeSkuWafMapping.class);

    public String securityPolicyName() {
        return this.securityPolicyName;
    }

    public ProfileChangeSkuWafMapping withSecurityPolicyName(String securityPolicyName) {
        this.securityPolicyName = securityPolicyName;
        return this;
    }

    public ResourceReference changeToWafPolicy() {
        return this.changeToWafPolicy;
    }

    public ProfileChangeSkuWafMapping withChangeToWafPolicy(ResourceReference changeToWafPolicy) {
        this.changeToWafPolicy = changeToWafPolicy;
        return this;
    }

    public void validate() {
        if (this.securityPolicyName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property securityPolicyName in model ProfileChangeSkuWafMapping"));
        }
        if (this.changeToWafPolicy() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property changeToWafPolicy in model ProfileChangeSkuWafMapping"));
        }
        this.changeToWafPolicy().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("securityPolicyName", this.securityPolicyName);
        jsonWriter.writeJsonField("changeToWafPolicy", (JsonSerializable)this.changeToWafPolicy);
        return jsonWriter.writeEndObject();
    }

    public static ProfileChangeSkuWafMapping fromJson(JsonReader jsonReader) throws IOException {
        return (ProfileChangeSkuWafMapping)jsonReader.readObject(reader -> {
            ProfileChangeSkuWafMapping deserializedProfileChangeSkuWafMapping = new ProfileChangeSkuWafMapping();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("securityPolicyName".equals(fieldName)) {
                    deserializedProfileChangeSkuWafMapping.securityPolicyName = reader.getString();
                    continue;
                }
                if ("changeToWafPolicy".equals(fieldName)) {
                    deserializedProfileChangeSkuWafMapping.changeToWafPolicy = ResourceReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedProfileChangeSkuWafMapping;
        });
    }
}

