/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.implementation;

import com.azure.resourcemanager.cdn.CdnManager;
import com.azure.resourcemanager.cdn.fluent.CdnManagementClient;
import com.azure.resourcemanager.cdn.fluent.models.CustomDomainInner;
import com.azure.resourcemanager.cdn.fluent.models.EndpointInner;
import com.azure.resourcemanager.cdn.implementation.CdnEndpointImpl;
import com.azure.resourcemanager.cdn.implementation.CdnProfileImpl;
import com.azure.resourcemanager.cdn.models.CdnEndpoint;
import com.azure.resourcemanager.cdn.models.CdnProfile;
import com.azure.resourcemanager.cdn.models.CheckNameAvailabilityResult;
import com.azure.resourcemanager.cdn.models.DeepCreatedOrigin;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.ExternalChildResourcesNonCachedImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class CdnEndpointsImpl
extends ExternalChildResourcesNonCachedImpl<CdnEndpointImpl, CdnEndpoint, EndpointInner, CdnProfileImpl, CdnProfile> {
    CdnEndpointsImpl(CdnProfileImpl parent) {
        super((Object)parent, parent.taskGroup(), "Endpoint");
    }

    Map<String, CdnEndpoint> endpointsAsMap() {
        HashMap<String, CdnEndpointImpl> result = new HashMap<String, CdnEndpointImpl>();
        for (EndpointInner endpointInner : ((CdnManagementClient)((CdnManager)((CdnProfileImpl)this.getParent()).manager()).serviceClient()).getEndpoints().listByProfile(((CdnProfileImpl)this.getParent()).resourceGroupName(), ((CdnProfileImpl)this.getParent()).name())) {
            CdnEndpointImpl endpoint = new CdnEndpointImpl(endpointInner.name(), (CdnProfileImpl)this.getParent(), endpointInner);
            for (CustomDomainInner customDomainInner : ((CdnManagementClient)((CdnManager)((CdnProfileImpl)this.getParent()).manager()).serviceClient()).getCustomDomains().listByEndpoint(((CdnProfileImpl)this.getParent()).resourceGroupName(), ((CdnProfileImpl)this.getParent()).name(), endpoint.name())) {
                endpoint.withCustomDomain(customDomainInner.hostname());
            }
            result.put(endpoint.name(), endpoint);
        }
        return Collections.unmodifiableMap(result);
    }

    public void remove(String name) {
        this.prepareInlineRemove(new CdnEndpointImpl(name, (CdnProfileImpl)this.getParent(), new EndpointInner()));
    }

    public void addEndpoint(CdnEndpointImpl endpoint) {
        this.childCollection.put(endpoint.name(), endpoint);
    }

    public CdnEndpointImpl defineNewEndpoint(String endpointName, String originName, String endpointOriginHostname) {
        CdnEndpointImpl endpoint = this.defineNewEndpoint(endpointName);
        ((EndpointInner)((Object)endpoint.innerModel())).origins().add(new DeepCreatedOrigin().withName(originName).withHostname(endpointOriginHostname));
        return endpoint;
    }

    public CdnEndpointImpl defineNewEndpoint(String endpointName, String endpointOriginHostname) {
        return this.defineNewEndpoint(endpointName, "origin", endpointOriginHostname);
    }

    public CdnEndpointImpl defineNewEndpoint(String name) {
        CdnEndpointImpl endpoint = (CdnEndpointImpl)this.prepareInlineDefine(new CdnEndpointImpl(name, (CdnProfileImpl)this.getParent(), new EndpointInner()));
        ((EndpointInner)((Object)endpoint.innerModel())).withLocation(((CdnProfileImpl)endpoint.parent()).region().toString());
        ((EndpointInner)((Object)endpoint.innerModel())).withOrigins(new ArrayList<DeepCreatedOrigin>());
        return endpoint;
    }

    public CdnEndpointImpl defineNewEndpoint() {
        String endpointName = this.generateUniqueEndpointName("Endpoint");
        return this.defineNewEndpoint(endpointName);
    }

    public CdnEndpointImpl defineNewEndpointWithOriginHostname(String endpointOriginHostname) {
        String endpointName = this.generateUniqueEndpointName("Endpoint");
        CdnEndpointImpl endpoint = this.defineNewEndpoint(endpointName, "origin", endpointOriginHostname);
        return endpoint;
    }

    public CdnEndpointImpl updateEndpoint(String name) {
        EndpointInner endpointInner = ((CdnManagementClient)((CdnManager)((CdnProfileImpl)this.getParent()).manager()).serviceClient()).getEndpoints().get(((CdnProfileImpl)this.getParent()).resourceGroupName(), ((CdnProfileImpl)this.getParent()).name(), name);
        CdnEndpointImpl endpoint = (CdnEndpointImpl)this.prepareInlineUpdate(new CdnEndpointImpl(name, (CdnProfileImpl)this.getParent(), endpointInner));
        return endpoint;
    }

    private String generateUniqueEndpointName(String endpointNamePrefix) {
        String endpointName;
        CheckNameAvailabilityResult result;
        do {
            endpointName = ((CdnManager)((CdnProfileImpl)this.getParent()).manager()).resourceManager().internalContext().randomResourceName(endpointNamePrefix, 50);
        } while (!(result = ((CdnProfileImpl)this.getParent()).checkEndpointNameAvailability(endpointName)).nameAvailable());
        return endpointName;
    }
}

