/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.AfdProvisioningState;
import com.azure.resourcemanager.cdn.models.AfdStateProperties;
import com.azure.resourcemanager.cdn.models.DeploymentStatus;
import com.azure.resourcemanager.cdn.models.SecretParameters;
import java.io.IOException;

public final class SecretProperties
extends AfdStateProperties {
    private String profileName;
    private SecretParameters parameters;
    private DeploymentStatus deploymentStatus;
    private AfdProvisioningState provisioningState;

    public String profileName() {
        return this.profileName;
    }

    public SecretParameters parameters() {
        return this.parameters;
    }

    public SecretProperties withParameters(SecretParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    @Override
    public DeploymentStatus deploymentStatus() {
        return this.deploymentStatus;
    }

    @Override
    public AfdProvisioningState provisioningState() {
        return this.provisioningState;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.parameters() != null) {
            this.parameters().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("parameters", (JsonSerializable)this.parameters);
        return jsonWriter.writeEndObject();
    }

    public static SecretProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SecretProperties)jsonReader.readObject(reader -> {
            SecretProperties deserializedSecretProperties = new SecretProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedSecretProperties.provisioningState = AfdProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("deploymentStatus".equals(fieldName)) {
                    deserializedSecretProperties.deploymentStatus = DeploymentStatus.fromString(reader.getString());
                    continue;
                }
                if ("profileName".equals(fieldName)) {
                    deserializedSecretProperties.profileName = reader.getString();
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    deserializedSecretProperties.parameters = SecretParameters.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSecretProperties;
        });
    }
}

