/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.ResourcesResponseCustomDomainsItem;
import com.azure.resourcemanager.cdn.models.ResourcesResponseEndpointsItem;
import java.io.IOException;
import java.util.List;

public final class ResourcesResponseInner
implements JsonSerializable<ResourcesResponseInner> {
    private List<ResourcesResponseEndpointsItem> endpoints;
    private List<ResourcesResponseCustomDomainsItem> customDomains;

    public List<ResourcesResponseEndpointsItem> endpoints() {
        return this.endpoints;
    }

    public ResourcesResponseInner withEndpoints(List<ResourcesResponseEndpointsItem> endpoints) {
        this.endpoints = endpoints;
        return this;
    }

    public List<ResourcesResponseCustomDomainsItem> customDomains() {
        return this.customDomains;
    }

    public ResourcesResponseInner withCustomDomains(List<ResourcesResponseCustomDomainsItem> customDomains) {
        this.customDomains = customDomains;
        return this;
    }

    public void validate() {
        if (this.endpoints() != null) {
            this.endpoints().forEach(e -> e.validate());
        }
        if (this.customDomains() != null) {
            this.customDomains().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("endpoints", this.endpoints, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("customDomains", this.customDomains, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ResourcesResponseInner fromJson(JsonReader jsonReader) throws IOException {
        return (ResourcesResponseInner)jsonReader.readObject(reader -> {
            ResourcesResponseInner deserializedResourcesResponseInner = new ResourcesResponseInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("endpoints".equals(fieldName)) {
                    List endpoints;
                    deserializedResourcesResponseInner.endpoints = endpoints = reader.readArray(reader1 -> ResourcesResponseEndpointsItem.fromJson(reader1));
                    continue;
                }
                if ("customDomains".equals(fieldName)) {
                    List customDomains;
                    deserializedResourcesResponseInner.customDomains = customDomains = reader.readArray(reader1 -> ResourcesResponseCustomDomainsItem.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourcesResponseInner;
        });
    }
}

