/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.ProfileLogScrubbing;
import java.io.IOException;

public final class ProfilePropertiesUpdateParameters
implements JsonSerializable<ProfilePropertiesUpdateParameters> {
    private Integer originResponseTimeoutSeconds;
    private ProfileLogScrubbing logScrubbing;

    public Integer originResponseTimeoutSeconds() {
        return this.originResponseTimeoutSeconds;
    }

    public ProfilePropertiesUpdateParameters withOriginResponseTimeoutSeconds(Integer originResponseTimeoutSeconds) {
        this.originResponseTimeoutSeconds = originResponseTimeoutSeconds;
        return this;
    }

    public ProfileLogScrubbing logScrubbing() {
        return this.logScrubbing;
    }

    public ProfilePropertiesUpdateParameters withLogScrubbing(ProfileLogScrubbing logScrubbing) {
        this.logScrubbing = logScrubbing;
        return this;
    }

    public void validate() {
        if (this.logScrubbing() != null) {
            this.logScrubbing().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("originResponseTimeoutSeconds", (Number)this.originResponseTimeoutSeconds);
        jsonWriter.writeJsonField("logScrubbing", (JsonSerializable)this.logScrubbing);
        return jsonWriter.writeEndObject();
    }

    public static ProfilePropertiesUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (ProfilePropertiesUpdateParameters)jsonReader.readObject(reader -> {
            ProfilePropertiesUpdateParameters deserializedProfilePropertiesUpdateParameters = new ProfilePropertiesUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("originResponseTimeoutSeconds".equals(fieldName)) {
                    deserializedProfilePropertiesUpdateParameters.originResponseTimeoutSeconds = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("logScrubbing".equals(fieldName)) {
                    deserializedProfilePropertiesUpdateParameters.logScrubbing = ProfileLogScrubbing.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedProfilePropertiesUpdateParameters;
        });
    }
}

