/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.fluent.models.EndpointPropertiesUpdateParameters;
import com.azure.resourcemanager.cdn.models.DeepCreatedCustomDomain;
import com.azure.resourcemanager.cdn.models.DeepCreatedOrigin;
import com.azure.resourcemanager.cdn.models.DeepCreatedOriginGroup;
import com.azure.resourcemanager.cdn.models.EndpointPropertiesUpdateParametersDeliveryPolicy;
import com.azure.resourcemanager.cdn.models.EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink;
import com.azure.resourcemanager.cdn.models.EndpointProvisioningState;
import com.azure.resourcemanager.cdn.models.EndpointResourceState;
import com.azure.resourcemanager.cdn.models.GeoFilter;
import com.azure.resourcemanager.cdn.models.OptimizationType;
import com.azure.resourcemanager.cdn.models.QueryStringCachingBehavior;
import com.azure.resourcemanager.cdn.models.ResourceReference;
import com.azure.resourcemanager.cdn.models.UrlSigningKey;
import java.io.IOException;
import java.util.List;

public final class EndpointProperties
extends EndpointPropertiesUpdateParameters {
    private String hostname;
    private List<DeepCreatedOrigin> origins;
    private List<DeepCreatedOriginGroup> originGroups;
    private List<DeepCreatedCustomDomain> customDomains;
    private EndpointResourceState resourceState;
    private EndpointProvisioningState provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(EndpointProperties.class);

    public String hostname() {
        return this.hostname;
    }

    public List<DeepCreatedOrigin> origins() {
        return this.origins;
    }

    public EndpointProperties withOrigins(List<DeepCreatedOrigin> origins) {
        this.origins = origins;
        return this;
    }

    public List<DeepCreatedOriginGroup> originGroups() {
        return this.originGroups;
    }

    public EndpointProperties withOriginGroups(List<DeepCreatedOriginGroup> originGroups) {
        this.originGroups = originGroups;
        return this;
    }

    public List<DeepCreatedCustomDomain> customDomains() {
        return this.customDomains;
    }

    public EndpointResourceState resourceState() {
        return this.resourceState;
    }

    public EndpointProvisioningState provisioningState() {
        return this.provisioningState;
    }

    @Override
    public EndpointProperties withOriginPath(String originPath) {
        super.withOriginPath(originPath);
        return this;
    }

    @Override
    public EndpointProperties withContentTypesToCompress(List<String> contentTypesToCompress) {
        super.withContentTypesToCompress(contentTypesToCompress);
        return this;
    }

    @Override
    public EndpointProperties withOriginHostHeader(String originHostHeader) {
        super.withOriginHostHeader(originHostHeader);
        return this;
    }

    @Override
    public EndpointProperties withIsCompressionEnabled(Boolean isCompressionEnabled) {
        super.withIsCompressionEnabled(isCompressionEnabled);
        return this;
    }

    @Override
    public EndpointProperties withIsHttpAllowed(Boolean isHttpAllowed) {
        super.withIsHttpAllowed(isHttpAllowed);
        return this;
    }

    @Override
    public EndpointProperties withIsHttpsAllowed(Boolean isHttpsAllowed) {
        super.withIsHttpsAllowed(isHttpsAllowed);
        return this;
    }

    @Override
    public EndpointProperties withQueryStringCachingBehavior(QueryStringCachingBehavior queryStringCachingBehavior) {
        super.withQueryStringCachingBehavior(queryStringCachingBehavior);
        return this;
    }

    @Override
    public EndpointProperties withOptimizationType(OptimizationType optimizationType) {
        super.withOptimizationType(optimizationType);
        return this;
    }

    @Override
    public EndpointProperties withProbePath(String probePath) {
        super.withProbePath(probePath);
        return this;
    }

    @Override
    public EndpointProperties withGeoFilters(List<GeoFilter> geoFilters) {
        super.withGeoFilters(geoFilters);
        return this;
    }

    @Override
    public EndpointProperties withDefaultOriginGroup(ResourceReference defaultOriginGroup) {
        super.withDefaultOriginGroup(defaultOriginGroup);
        return this;
    }

    @Override
    public EndpointProperties withUrlSigningKeys(List<UrlSigningKey> urlSigningKeys) {
        super.withUrlSigningKeys(urlSigningKeys);
        return this;
    }

    @Override
    public EndpointProperties withDeliveryPolicy(EndpointPropertiesUpdateParametersDeliveryPolicy deliveryPolicy) {
        super.withDeliveryPolicy(deliveryPolicy);
        return this;
    }

    @Override
    public EndpointProperties withWebApplicationFirewallPolicyLink(EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink webApplicationFirewallPolicyLink) {
        super.withWebApplicationFirewallPolicyLink(webApplicationFirewallPolicyLink);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.origins() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property origins in model EndpointProperties"));
        }
        this.origins().forEach(e -> e.validate());
        if (this.originGroups() != null) {
            this.originGroups().forEach(e -> e.validate());
        }
        if (this.customDomains() != null) {
            this.customDomains().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("originPath", this.originPath());
        jsonWriter.writeArrayField("contentTypesToCompress", this.contentTypesToCompress(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("originHostHeader", this.originHostHeader());
        jsonWriter.writeBooleanField("isCompressionEnabled", this.isCompressionEnabled());
        jsonWriter.writeBooleanField("isHttpAllowed", this.isHttpAllowed());
        jsonWriter.writeBooleanField("isHttpsAllowed", this.isHttpsAllowed());
        jsonWriter.writeStringField("queryStringCachingBehavior", this.queryStringCachingBehavior() == null ? null : this.queryStringCachingBehavior().toString());
        jsonWriter.writeStringField("optimizationType", this.optimizationType() == null ? null : this.optimizationType().toString());
        jsonWriter.writeStringField("probePath", this.probePath());
        jsonWriter.writeArrayField("geoFilters", this.geoFilters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("defaultOriginGroup", (JsonSerializable)this.defaultOriginGroup());
        jsonWriter.writeArrayField("urlSigningKeys", this.urlSigningKeys(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("deliveryPolicy", (JsonSerializable)this.deliveryPolicy());
        jsonWriter.writeJsonField("webApplicationFirewallPolicyLink", (JsonSerializable)this.webApplicationFirewallPolicyLink());
        jsonWriter.writeArrayField("origins", this.origins, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("originGroups", this.originGroups, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static EndpointProperties fromJson(JsonReader jsonReader) throws IOException {
        return (EndpointProperties)jsonReader.readObject(reader -> {
            EndpointProperties deserializedEndpointProperties = new EndpointProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("originPath".equals(fieldName)) {
                    deserializedEndpointProperties.withOriginPath(reader.getString());
                    continue;
                }
                if ("contentTypesToCompress".equals(fieldName)) {
                    List contentTypesToCompress = reader.readArray(reader1 -> reader1.getString());
                    deserializedEndpointProperties.withContentTypesToCompress(contentTypesToCompress);
                    continue;
                }
                if ("originHostHeader".equals(fieldName)) {
                    deserializedEndpointProperties.withOriginHostHeader(reader.getString());
                    continue;
                }
                if ("isCompressionEnabled".equals(fieldName)) {
                    deserializedEndpointProperties.withIsCompressionEnabled((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("isHttpAllowed".equals(fieldName)) {
                    deserializedEndpointProperties.withIsHttpAllowed((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("isHttpsAllowed".equals(fieldName)) {
                    deserializedEndpointProperties.withIsHttpsAllowed((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("queryStringCachingBehavior".equals(fieldName)) {
                    deserializedEndpointProperties.withQueryStringCachingBehavior(QueryStringCachingBehavior.fromString(reader.getString()));
                    continue;
                }
                if ("optimizationType".equals(fieldName)) {
                    deserializedEndpointProperties.withOptimizationType(OptimizationType.fromString(reader.getString()));
                    continue;
                }
                if ("probePath".equals(fieldName)) {
                    deserializedEndpointProperties.withProbePath(reader.getString());
                    continue;
                }
                if ("geoFilters".equals(fieldName)) {
                    List geoFilters = reader.readArray(reader1 -> GeoFilter.fromJson(reader1));
                    deserializedEndpointProperties.withGeoFilters(geoFilters);
                    continue;
                }
                if ("defaultOriginGroup".equals(fieldName)) {
                    deserializedEndpointProperties.withDefaultOriginGroup(ResourceReference.fromJson(reader));
                    continue;
                }
                if ("urlSigningKeys".equals(fieldName)) {
                    List urlSigningKeys = reader.readArray(reader1 -> UrlSigningKey.fromJson(reader1));
                    deserializedEndpointProperties.withUrlSigningKeys(urlSigningKeys);
                    continue;
                }
                if ("deliveryPolicy".equals(fieldName)) {
                    deserializedEndpointProperties.withDeliveryPolicy(EndpointPropertiesUpdateParametersDeliveryPolicy.fromJson(reader));
                    continue;
                }
                if ("webApplicationFirewallPolicyLink".equals(fieldName)) {
                    deserializedEndpointProperties.withWebApplicationFirewallPolicyLink(EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink.fromJson(reader));
                    continue;
                }
                if ("origins".equals(fieldName)) {
                    List origins;
                    deserializedEndpointProperties.origins = origins = reader.readArray(reader1 -> DeepCreatedOrigin.fromJson(reader1));
                    continue;
                }
                if ("hostName".equals(fieldName)) {
                    deserializedEndpointProperties.hostname = reader.getString();
                    continue;
                }
                if ("originGroups".equals(fieldName)) {
                    List originGroups;
                    deserializedEndpointProperties.originGroups = originGroups = reader.readArray(reader1 -> DeepCreatedOriginGroup.fromJson(reader1));
                    continue;
                }
                if ("customDomains".equals(fieldName)) {
                    List customDomains;
                    deserializedEndpointProperties.customDomains = customDomains = reader.readArray(reader1 -> DeepCreatedCustomDomain.fromJson(reader1));
                    continue;
                }
                if ("resourceState".equals(fieldName)) {
                    deserializedEndpointProperties.resourceState = EndpointResourceState.fromString(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedEndpointProperties.provisioningState = EndpointProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEndpointProperties;
        });
    }
}

