/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.WafMetricsResponseSeriesItemData;
import com.azure.resourcemanager.cdn.models.WafMetricsResponseSeriesPropertiesItemsItem;
import com.azure.resourcemanager.cdn.models.WafMetricsSeriesUnit;
import java.io.IOException;
import java.util.List;

public final class WafMetricsResponseSeriesItem
implements JsonSerializable<WafMetricsResponseSeriesItem> {
    private String metric;
    private WafMetricsSeriesUnit unit;
    private List<WafMetricsResponseSeriesPropertiesItemsItem> groups;
    private List<WafMetricsResponseSeriesItemData> data;

    public String metric() {
        return this.metric;
    }

    public WafMetricsResponseSeriesItem withMetric(String metric) {
        this.metric = metric;
        return this;
    }

    public WafMetricsSeriesUnit unit() {
        return this.unit;
    }

    public WafMetricsResponseSeriesItem withUnit(WafMetricsSeriesUnit unit) {
        this.unit = unit;
        return this;
    }

    public List<WafMetricsResponseSeriesPropertiesItemsItem> groups() {
        return this.groups;
    }

    public WafMetricsResponseSeriesItem withGroups(List<WafMetricsResponseSeriesPropertiesItemsItem> groups) {
        this.groups = groups;
        return this;
    }

    public List<WafMetricsResponseSeriesItemData> data() {
        return this.data;
    }

    public WafMetricsResponseSeriesItem withData(List<WafMetricsResponseSeriesItemData> data) {
        this.data = data;
        return this;
    }

    public void validate() {
        if (this.groups() != null) {
            this.groups().forEach(e -> e.validate());
        }
        if (this.data() != null) {
            this.data().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("metric", this.metric);
        jsonWriter.writeStringField("unit", this.unit == null ? null : this.unit.toString());
        jsonWriter.writeArrayField("groups", this.groups, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("data", this.data, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static WafMetricsResponseSeriesItem fromJson(JsonReader jsonReader) throws IOException {
        return (WafMetricsResponseSeriesItem)jsonReader.readObject(reader -> {
            WafMetricsResponseSeriesItem deserializedWafMetricsResponseSeriesItem = new WafMetricsResponseSeriesItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("metric".equals(fieldName)) {
                    deserializedWafMetricsResponseSeriesItem.metric = reader.getString();
                    continue;
                }
                if ("unit".equals(fieldName)) {
                    deserializedWafMetricsResponseSeriesItem.unit = WafMetricsSeriesUnit.fromString(reader.getString());
                    continue;
                }
                if ("groups".equals(fieldName)) {
                    List groups;
                    deserializedWafMetricsResponseSeriesItem.groups = groups = reader.readArray(reader1 -> WafMetricsResponseSeriesPropertiesItemsItem.fromJson(reader1));
                    continue;
                }
                if ("data".equals(fieldName)) {
                    List data;
                    deserializedWafMetricsResponseSeriesItem.data = data = reader.readArray(reader1 -> WafMetricsResponseSeriesItemData.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWafMetricsResponseSeriesItem;
        });
    }
}

