/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.DeliveryRuleCondition;
import com.azure.resourcemanager.cdn.models.MatchVariable;
import com.azure.resourcemanager.cdn.models.SocketAddrMatchConditionParameters;
import java.io.IOException;

public final class DeliveryRuleSocketAddrCondition
extends DeliveryRuleCondition {
    private MatchVariable name = MatchVariable.SOCKET_ADDR;
    private SocketAddrMatchConditionParameters parameters;
    private static final ClientLogger LOGGER = new ClientLogger(DeliveryRuleSocketAddrCondition.class);

    @Override
    public MatchVariable name() {
        return this.name;
    }

    public SocketAddrMatchConditionParameters parameters() {
        return this.parameters;
    }

    public DeliveryRuleSocketAddrCondition withParameters(SocketAddrMatchConditionParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.parameters() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property parameters in model DeliveryRuleSocketAddrCondition"));
        }
        this.parameters().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("parameters", (JsonSerializable)this.parameters);
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        return jsonWriter.writeEndObject();
    }

    public static DeliveryRuleSocketAddrCondition fromJson(JsonReader jsonReader) throws IOException {
        return (DeliveryRuleSocketAddrCondition)jsonReader.readObject(reader -> {
            DeliveryRuleSocketAddrCondition deserializedDeliveryRuleSocketAddrCondition = new DeliveryRuleSocketAddrCondition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("parameters".equals(fieldName)) {
                    deserializedDeliveryRuleSocketAddrCondition.parameters = SocketAddrMatchConditionParameters.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDeliveryRuleSocketAddrCondition.name = MatchVariable.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeliveryRuleSocketAddrCondition;
        });
    }
}

