/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.ActionType;
import com.azure.resourcemanager.cdn.models.CustomRuleEnabledState;
import com.azure.resourcemanager.cdn.models.MatchCondition;
import java.io.IOException;
import java.util.List;

public class CustomRule
implements JsonSerializable<CustomRule> {
    private String name;
    private CustomRuleEnabledState enabledState;
    private int priority;
    private List<MatchCondition> matchConditions;
    private ActionType action;
    private static final ClientLogger LOGGER = new ClientLogger(CustomRule.class);

    public String name() {
        return this.name;
    }

    public CustomRule withName(String name) {
        this.name = name;
        return this;
    }

    public CustomRuleEnabledState enabledState() {
        return this.enabledState;
    }

    public CustomRule withEnabledState(CustomRuleEnabledState enabledState) {
        this.enabledState = enabledState;
        return this;
    }

    public int priority() {
        return this.priority;
    }

    public CustomRule withPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public List<MatchCondition> matchConditions() {
        return this.matchConditions;
    }

    public CustomRule withMatchConditions(List<MatchCondition> matchConditions) {
        this.matchConditions = matchConditions;
        return this;
    }

    public ActionType action() {
        return this.action;
    }

    public CustomRule withAction(ActionType action) {
        this.action = action;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model CustomRule"));
        }
        if (this.matchConditions() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property matchConditions in model CustomRule"));
        }
        this.matchConditions().forEach(e -> e.validate());
        if (this.action() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property action in model CustomRule"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeIntField("priority", this.priority);
        jsonWriter.writeArrayField("matchConditions", this.matchConditions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("action", this.action == null ? null : this.action.toString());
        jsonWriter.writeStringField("enabledState", this.enabledState == null ? null : this.enabledState.toString());
        return jsonWriter.writeEndObject();
    }

    public static CustomRule fromJson(JsonReader jsonReader) throws IOException {
        return (CustomRule)jsonReader.readObject(reader -> {
            CustomRule deserializedCustomRule = new CustomRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedCustomRule.name = reader.getString();
                    continue;
                }
                if ("priority".equals(fieldName)) {
                    deserializedCustomRule.priority = reader.getInt();
                    continue;
                }
                if ("matchConditions".equals(fieldName)) {
                    List matchConditions;
                    deserializedCustomRule.matchConditions = matchConditions = reader.readArray(reader1 -> MatchCondition.fromJson(reader1));
                    continue;
                }
                if ("action".equals(fieldName)) {
                    deserializedCustomRule.action = ActionType.fromString(reader.getString());
                    continue;
                }
                if ("enabledState".equals(fieldName)) {
                    deserializedCustomRule.enabledState = CustomRuleEnabledState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCustomRule;
        });
    }
}

