/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.resourcemanager.cdn.fluent.models.ProfilePropertiesUpdateParameters;
import com.azure.resourcemanager.cdn.models.ManagedServiceIdentity;
import com.azure.resourcemanager.cdn.models.ProfileLogScrubbing;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public final class ProfileUpdateParameters {
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, String> tags;
    @JsonProperty(value="identity")
    private ManagedServiceIdentity identity;
    @JsonProperty(value="properties")
    private ProfilePropertiesUpdateParameters innerProperties;

    public Map<String, String> tags() {
        return this.tags;
    }

    public ProfileUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public ProfileUpdateParameters withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    private ProfilePropertiesUpdateParameters innerProperties() {
        return this.innerProperties;
    }

    public Integer originResponseTimeoutSeconds() {
        return this.innerProperties() == null ? null : this.innerProperties().originResponseTimeoutSeconds();
    }

    public ProfileUpdateParameters withOriginResponseTimeoutSeconds(Integer originResponseTimeoutSeconds) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProfilePropertiesUpdateParameters();
        }
        this.innerProperties().withOriginResponseTimeoutSeconds(originResponseTimeoutSeconds);
        return this;
    }

    public ProfileLogScrubbing logScrubbing() {
        return this.innerProperties() == null ? null : this.innerProperties().logScrubbing();
    }

    public ProfileUpdateParameters withLogScrubbing(ProfileLogScrubbing logScrubbing) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProfilePropertiesUpdateParameters();
        }
        this.innerProperties().withLogScrubbing(logScrubbing);
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

