// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * Defines how Frontdoor caches requests that include query strings. You can ignore any query strings when caching,
 * ignore specific query strings, cache every request with a unique URL, or cache specific query strings.
 */
public final class AfdQueryStringCachingBehavior extends ExpandableStringEnum<AfdQueryStringCachingBehavior> {
    /**
     * Static value IgnoreQueryString for AfdQueryStringCachingBehavior.
     */
    public static final AfdQueryStringCachingBehavior IGNORE_QUERY_STRING = fromString("IgnoreQueryString");

    /**
     * Static value UseQueryString for AfdQueryStringCachingBehavior.
     */
    public static final AfdQueryStringCachingBehavior USE_QUERY_STRING = fromString("UseQueryString");

    /**
     * Static value IgnoreSpecifiedQueryStrings for AfdQueryStringCachingBehavior.
     */
    public static final AfdQueryStringCachingBehavior IGNORE_SPECIFIED_QUERY_STRINGS
        = fromString("IgnoreSpecifiedQueryStrings");

    /**
     * Static value IncludeSpecifiedQueryStrings for AfdQueryStringCachingBehavior.
     */
    public static final AfdQueryStringCachingBehavior INCLUDE_SPECIFIED_QUERY_STRINGS
        = fromString("IncludeSpecifiedQueryStrings");

    /**
     * Creates a new instance of AfdQueryStringCachingBehavior value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public AfdQueryStringCachingBehavior() {
    }

    /**
     * Creates or finds a AfdQueryStringCachingBehavior from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding AfdQueryStringCachingBehavior.
     */
    @JsonCreator
    public static AfdQueryStringCachingBehavior fromString(String name) {
        return fromString(name, AfdQueryStringCachingBehavior.class);
    }

    /**
     * Gets known AfdQueryStringCachingBehavior values.
     * 
     * @return known AfdQueryStringCachingBehavior values.
     */
    public static Collection<AfdQueryStringCachingBehavior> values() {
        return values(AfdQueryStringCachingBehavior.class);
    }
}
