// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.cdn.fluent.AfdOriginGroupsClient;
import com.azure.resourcemanager.cdn.fluent.models.AfdOriginGroupInner;
import com.azure.resourcemanager.cdn.fluent.models.UsageInner;
import com.azure.resourcemanager.cdn.models.AfdOriginGroupListResult;
import com.azure.resourcemanager.cdn.models.AfdOriginGroupUpdateParameters;
import com.azure.resourcemanager.cdn.models.UsagesListResult;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in AfdOriginGroupsClient.
 */
public final class AfdOriginGroupsClientImpl implements AfdOriginGroupsClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final AfdOriginGroupsService service;

    /**
     * The service client containing this operation class.
     */
    private final CdnManagementClientImpl client;

    /**
     * Initializes an instance of AfdOriginGroupsClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    AfdOriginGroupsClientImpl(CdnManagementClientImpl client) {
        this.service
            = RestProxy.create(AfdOriginGroupsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for CdnManagementClientAfdOriginGroups to be used by the proxy service
     * to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "CdnManagementClientA")
    public interface AfdOriginGroupsService {
        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/originGroups")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<AfdOriginGroupListResult>> listByProfile(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("profileName") String profileName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/originGroups/{originGroupName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<AfdOriginGroupInner>> get(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("profileName") String profileName,
            @PathParam("originGroupName") String originGroupName, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/originGroups/{originGroupName}")
        @ExpectedResponses({ 200, 201, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> create(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("profileName") String profileName,
            @PathParam("originGroupName") String originGroupName, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") AfdOriginGroupInner originGroup, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Patch("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/originGroups/{originGroupName}")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> update(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("profileName") String profileName,
            @PathParam("originGroupName") String originGroupName, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") AfdOriginGroupUpdateParameters originGroupUpdateProperties,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/originGroups/{originGroupName}")
        @ExpectedResponses({ 200, 202, 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> delete(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("profileName") String profileName,
            @PathParam("originGroupName") String originGroupName, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/originGroups/{originGroupName}/usages")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<UsagesListResult>> listResourceUsage(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("profileName") String profileName,
            @PathParam("originGroupName") String originGroupName, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<AfdOriginGroupListResult>> listByProfileNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<UsagesListResult>> listResourceUsageNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Lists all of the existing origin groups within a profile.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
     * within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list origin groups along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<AfdOriginGroupInner>> listByProfileSinglePageAsync(String resourceGroupName,
        String profileName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByProfile(this.client.getEndpoint(), resourceGroupName, profileName,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .<PagedResponse<AfdOriginGroupInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists all of the existing origin groups within a profile.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
     * within the resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list origin groups along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<AfdOriginGroupInner>> listByProfileSinglePageAsync(String resourceGroupName,
        String profileName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByProfile(this.client.getEndpoint(), resourceGroupName, profileName, this.client.getSubscriptionId(),
                this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Lists all of the existing origin groups within a profile.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
     * within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list origin groups as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<AfdOriginGroupInner> listByProfileAsync(String resourceGroupName, String profileName) {
        return new PagedFlux<>(() -> listByProfileSinglePageAsync(resourceGroupName, profileName),
            nextLink -> listByProfileNextSinglePageAsync(nextLink));
    }

    /**
     * Lists all of the existing origin groups within a profile.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
     * within the resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list origin groups as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<AfdOriginGroupInner> listByProfileAsync(String resourceGroupName, String profileName,
        Context context) {
        return new PagedFlux<>(() -> listByProfileSinglePageAsync(resourceGroupName, profileName, context),
            nextLink -> listByProfileNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists all of the existing origin groups within a profile.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
     * within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list origin groups as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<AfdOriginGroupInner> listByProfile(String resourceGroupName, String profileName) {
        return new PagedIterable<>(listByProfileAsync(resourceGroupName, profileName));
    }

    /**
     * Lists all of the existing origin groups within a profile.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
     * within the resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list origin groups as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<AfdOriginGroupInner> listByProfile(String resourceGroupName, String profileName,
        Context context) {
        return new PagedIterable<>(listByProfileAsync(resourceGroupName, profileName, context));
    }

    /**
     * Gets an existing origin group within a profile.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
     * within the resource group.
     * @param originGroupName Name of the origin group which is unique within the endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an existing origin group within a profile along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AfdOriginGroupInner>> getWithResponseAsync(String resourceGroupName, String profileName,
        String originGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (originGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter originGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.get(this.client.getEndpoint(), resourceGroupName, profileName,
                originGroupName, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets an existing origin group within a profile.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
     * within the resource group.
     * @param originGroupName Name of the origin group which is unique within the endpoint.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an existing origin group within a profile along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<AfdOriginGroupInner>> getWithResponseAsync(String resourceGroupName, String profileName,
        String originGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (originGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter originGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.get(this.client.getEndpoint(), resourceGroupName, profileName, originGroupName,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets an existing origin group within a profile.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
     * within the resource group.
     * @param originGroupName Name of the origin group which is unique within the endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an existing origin group within a profile on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AfdOriginGroupInner> getAsync(String resourceGroupName, String profileName, String originGroupName) {
        return getWithResponseAsync(resourceGroupName, profileName, originGroupName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets an existing origin group within a profile.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
     * within the resource group.
     * @param originGroupName Name of the origin group which is unique within the endpoint.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an existing origin group within a profile along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<AfdOriginGroupInner> getWithResponse(String resourceGroupName, String profileName,
        String originGroupName, Context context) {
        return getWithResponseAsync(resourceGroupName, profileName, originGroupName, context).block();
    }

    /**
     * Gets an existing origin group within a profile.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
     * within the resource group.
     * @param originGroupName Name of the origin group which is unique within the endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an existing origin group within a profile.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AfdOriginGroupInner get(String resourceGroupName, String profileName, String originGroupName) {
        return getWithResponse(resourceGroupName, profileName, originGroupName, Context.NONE).getValue();
    }

    /**
     * Creates a new origin group within the specified profile.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
     * within the resource group.
     * @param originGroupName Name of the origin group which is unique within the endpoint.
     * @param originGroup Origin group properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return aFDOrigin group comprising of origins is used for load balancing to origins when the content cannot be
     * served from Azure Front Door along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String profileName,
        String originGroupName, AfdOriginGroupInner originGroup) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (originGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter originGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (originGroup == null) {
            return Mono.error(new IllegalArgumentException("Parameter originGroup is required and cannot be null."));
        } else {
            originGroup.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.create(this.client.getEndpoint(), resourceGroupName, profileName, originGroupName,
                    this.client.getSubscriptionId(), this.client.getApiVersion(), originGroup, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Creates a new origin group within the specified profile.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
     * within the resource group.
     * @param originGroupName Name of the origin group which is unique within the endpoint.
     * @param originGroup Origin group properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return aFDOrigin group comprising of origins is used for load balancing to origins when the content cannot be
     * served from Azure Front Door along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String profileName,
        String originGroupName, AfdOriginGroupInner originGroup, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (originGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter originGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (originGroup == null) {
            return Mono.error(new IllegalArgumentException("Parameter originGroup is required and cannot be null."));
        } else {
            originGroup.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.create(this.client.getEndpoint(), resourceGroupName, profileName, originGroupName,
            this.client.getSubscriptionId(), this.client.getApiVersion(), originGroup, accept, context);
    }

    /**
     * Creates a new origin group within the specified profile.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
     * within the resource group.
     * @param originGroupName Name of the origin group which is unique within the endpoint.
     * @param originGroup Origin group properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of aFDOrigin group comprising of origins is used for load balancing to
     * origins when the content cannot be served from Azure Front Door.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<AfdOriginGroupInner>, AfdOriginGroupInner> beginCreateAsync(String resourceGroupName,
        String profileName, String originGroupName, AfdOriginGroupInner originGroup) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = createWithResponseAsync(resourceGroupName, profileName, originGroupName, originGroup);
        return this.client.<AfdOriginGroupInner, AfdOriginGroupInner>getLroResult(mono, this.client.getHttpPipeline(),
            AfdOriginGroupInner.class, AfdOriginGroupInner.class, this.client.getContext());
    }

    /**
     * Creates a new origin group within the specified profile.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
     * within the resource group.
     * @param originGroupName Name of the origin group which is unique within the endpoint.
     * @param originGroup Origin group properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of aFDOrigin group comprising of origins is used for load balancing to
     * origins when the content cannot be served from Azure Front Door.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<AfdOriginGroupInner>, AfdOriginGroupInner> beginCreateAsync(String resourceGroupName,
        String profileName, String originGroupName, AfdOriginGroupInner originGroup, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = createWithResponseAsync(resourceGroupName, profileName, originGroupName, originGroup, context);
        return this.client.<AfdOriginGroupInner, AfdOriginGroupInner>getLroResult(mono, this.client.getHttpPipeline(),
            AfdOriginGroupInner.class, AfdOriginGroupInner.class, context);
    }

    /**
     * Creates a new origin group within the specified profile.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
     * within the resource group.
     * @param originGroupName Name of the origin group which is unique within the endpoint.
     * @param originGroup Origin group properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of aFDOrigin group comprising of origins is used for load balancing to
     * origins when the content cannot be served from Azure Front Door.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AfdOriginGroupInner>, AfdOriginGroupInner> beginCreate(String resourceGroupName,
        String profileName, String originGroupName, AfdOriginGroupInner originGroup) {
        return this.beginCreateAsync(resourceGroupName, profileName, originGroupName, originGroup).getSyncPoller();
    }

    /**
     * Creates a new origin group within the specified profile.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
     * within the resource group.
     * @param originGroupName Name of the origin group which is unique within the endpoint.
     * @param originGroup Origin group properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of aFDOrigin group comprising of origins is used for load balancing to
     * origins when the content cannot be served from Azure Front Door.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AfdOriginGroupInner>, AfdOriginGroupInner> beginCreate(String resourceGroupName,
        String profileName, String originGroupName, AfdOriginGroupInner originGroup, Context context) {
        return this.beginCreateAsync(resourceGroupName, profileName, originGroupName, originGroup, context)
            .getSyncPoller();
    }

    /**
     * Creates a new origin group within the specified profile.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
     * within the resource group.
     * @param originGroupName Name of the origin group which is unique within the endpoint.
     * @param originGroup Origin group properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return aFDOrigin group comprising of origins is used for load balancing to origins when the content cannot be
     * served from Azure Front Door on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AfdOriginGroupInner> createAsync(String resourceGroupName, String profileName, String originGroupName,
        AfdOriginGroupInner originGroup) {
        return beginCreateAsync(resourceGroupName, profileName, originGroupName, originGroup).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates a new origin group within the specified profile.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
     * within the resource group.
     * @param originGroupName Name of the origin group which is unique within the endpoint.
     * @param originGroup Origin group properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return aFDOrigin group comprising of origins is used for load balancing to origins when the content cannot be
     * served from Azure Front Door on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<AfdOriginGroupInner> createAsync(String resourceGroupName, String profileName, String originGroupName,
        AfdOriginGroupInner originGroup, Context context) {
        return beginCreateAsync(resourceGroupName, profileName, originGroupName, originGroup, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates a new origin group within the specified profile.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
     * within the resource group.
     * @param originGroupName Name of the origin group which is unique within the endpoint.
     * @param originGroup Origin group properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return aFDOrigin group comprising of origins is used for load balancing to origins when the content cannot be
     * served from Azure Front Door.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AfdOriginGroupInner create(String resourceGroupName, String profileName, String originGroupName,
        AfdOriginGroupInner originGroup) {
        return createAsync(resourceGroupName, profileName, originGroupName, originGroup).block();
    }

    /**
     * Creates a new origin group within the specified profile.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
     * within the resource group.
     * @param originGroupName Name of the origin group which is unique within the endpoint.
     * @param originGroup Origin group properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return aFDOrigin group comprising of origins is used for load balancing to origins when the content cannot be
     * served from Azure Front Door.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AfdOriginGroupInner create(String resourceGroupName, String profileName, String originGroupName,
        AfdOriginGroupInner originGroup, Context context) {
        return createAsync(resourceGroupName, profileName, originGroupName, originGroup, context).block();
    }

    /**
     * Updates an existing origin group within a profile.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
     * within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originGroupUpdateProperties Origin group properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return aFDOrigin group comprising of origins is used for load balancing to origins when the content cannot be
     * served from Azure Front Door along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String profileName,
        String originGroupName, AfdOriginGroupUpdateParameters originGroupUpdateProperties) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (originGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter originGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (originGroupUpdateProperties == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter originGroupUpdateProperties is required and cannot be null."));
        } else {
            originGroupUpdateProperties.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.update(this.client.getEndpoint(), resourceGroupName, profileName,
                originGroupName, this.client.getSubscriptionId(), this.client.getApiVersion(),
                originGroupUpdateProperties, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Updates an existing origin group within a profile.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
     * within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originGroupUpdateProperties Origin group properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return aFDOrigin group comprising of origins is used for load balancing to origins when the content cannot be
     * served from Azure Front Door along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String profileName,
        String originGroupName, AfdOriginGroupUpdateParameters originGroupUpdateProperties, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (originGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter originGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (originGroupUpdateProperties == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter originGroupUpdateProperties is required and cannot be null."));
        } else {
            originGroupUpdateProperties.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.update(this.client.getEndpoint(), resourceGroupName, profileName, originGroupName,
            this.client.getSubscriptionId(), this.client.getApiVersion(), originGroupUpdateProperties, accept, context);
    }

    /**
     * Updates an existing origin group within a profile.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
     * within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originGroupUpdateProperties Origin group properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of aFDOrigin group comprising of origins is used for load balancing to
     * origins when the content cannot be served from Azure Front Door.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<AfdOriginGroupInner>, AfdOriginGroupInner> beginUpdateAsync(String resourceGroupName,
        String profileName, String originGroupName, AfdOriginGroupUpdateParameters originGroupUpdateProperties) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = updateWithResponseAsync(resourceGroupName, profileName, originGroupName, originGroupUpdateProperties);
        return this.client.<AfdOriginGroupInner, AfdOriginGroupInner>getLroResult(mono, this.client.getHttpPipeline(),
            AfdOriginGroupInner.class, AfdOriginGroupInner.class, this.client.getContext());
    }

    /**
     * Updates an existing origin group within a profile.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
     * within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originGroupUpdateProperties Origin group properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of aFDOrigin group comprising of origins is used for load balancing to
     * origins when the content cannot be served from Azure Front Door.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<AfdOriginGroupInner>, AfdOriginGroupInner> beginUpdateAsync(String resourceGroupName,
        String profileName, String originGroupName, AfdOriginGroupUpdateParameters originGroupUpdateProperties,
        Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = updateWithResponseAsync(resourceGroupName, profileName, originGroupName,
            originGroupUpdateProperties, context);
        return this.client.<AfdOriginGroupInner, AfdOriginGroupInner>getLroResult(mono, this.client.getHttpPipeline(),
            AfdOriginGroupInner.class, AfdOriginGroupInner.class, context);
    }

    /**
     * Updates an existing origin group within a profile.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
     * within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originGroupUpdateProperties Origin group properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of aFDOrigin group comprising of origins is used for load balancing to
     * origins when the content cannot be served from Azure Front Door.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AfdOriginGroupInner>, AfdOriginGroupInner> beginUpdate(String resourceGroupName,
        String profileName, String originGroupName, AfdOriginGroupUpdateParameters originGroupUpdateProperties) {
        return this.beginUpdateAsync(resourceGroupName, profileName, originGroupName, originGroupUpdateProperties)
            .getSyncPoller();
    }

    /**
     * Updates an existing origin group within a profile.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
     * within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originGroupUpdateProperties Origin group properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of aFDOrigin group comprising of origins is used for load balancing to
     * origins when the content cannot be served from Azure Front Door.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AfdOriginGroupInner>, AfdOriginGroupInner> beginUpdate(String resourceGroupName,
        String profileName, String originGroupName, AfdOriginGroupUpdateParameters originGroupUpdateProperties,
        Context context) {
        return this
            .beginUpdateAsync(resourceGroupName, profileName, originGroupName, originGroupUpdateProperties, context)
            .getSyncPoller();
    }

    /**
     * Updates an existing origin group within a profile.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
     * within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originGroupUpdateProperties Origin group properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return aFDOrigin group comprising of origins is used for load balancing to origins when the content cannot be
     * served from Azure Front Door on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AfdOriginGroupInner> updateAsync(String resourceGroupName, String profileName, String originGroupName,
        AfdOriginGroupUpdateParameters originGroupUpdateProperties) {
        return beginUpdateAsync(resourceGroupName, profileName, originGroupName, originGroupUpdateProperties).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Updates an existing origin group within a profile.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
     * within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originGroupUpdateProperties Origin group properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return aFDOrigin group comprising of origins is used for load balancing to origins when the content cannot be
     * served from Azure Front Door on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<AfdOriginGroupInner> updateAsync(String resourceGroupName, String profileName, String originGroupName,
        AfdOriginGroupUpdateParameters originGroupUpdateProperties, Context context) {
        return beginUpdateAsync(resourceGroupName, profileName, originGroupName, originGroupUpdateProperties, context)
            .last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Updates an existing origin group within a profile.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
     * within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originGroupUpdateProperties Origin group properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return aFDOrigin group comprising of origins is used for load balancing to origins when the content cannot be
     * served from Azure Front Door.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AfdOriginGroupInner update(String resourceGroupName, String profileName, String originGroupName,
        AfdOriginGroupUpdateParameters originGroupUpdateProperties) {
        return updateAsync(resourceGroupName, profileName, originGroupName, originGroupUpdateProperties).block();
    }

    /**
     * Updates an existing origin group within a profile.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
     * within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param originGroupUpdateProperties Origin group properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return aFDOrigin group comprising of origins is used for load balancing to origins when the content cannot be
     * served from Azure Front Door.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AfdOriginGroupInner update(String resourceGroupName, String profileName, String originGroupName,
        AfdOriginGroupUpdateParameters originGroupUpdateProperties, Context context) {
        return updateAsync(resourceGroupName, profileName, originGroupName, originGroupUpdateProperties, context)
            .block();
    }

    /**
     * Deletes an existing origin group within a profile.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
     * within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String profileName,
        String originGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (originGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter originGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.delete(this.client.getEndpoint(), resourceGroupName, profileName,
                originGroupName, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes an existing origin group within a profile.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
     * within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String profileName,
        String originGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (originGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter originGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.delete(this.client.getEndpoint(), resourceGroupName, profileName, originGroupName,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Deletes an existing origin group within a profile.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
     * within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String profileName,
        String originGroupName) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteWithResponseAsync(resourceGroupName, profileName, originGroupName);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Deletes an existing origin group within a profile.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
     * within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String profileName,
        String originGroupName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteWithResponseAsync(resourceGroupName, profileName, originGroupName, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Deletes an existing origin group within a profile.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
     * within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String profileName,
        String originGroupName) {
        return this.beginDeleteAsync(resourceGroupName, profileName, originGroupName).getSyncPoller();
    }

    /**
     * Deletes an existing origin group within a profile.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
     * within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String profileName,
        String originGroupName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, profileName, originGroupName, context).getSyncPoller();
    }

    /**
     * Deletes an existing origin group within a profile.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
     * within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String profileName, String originGroupName) {
        return beginDeleteAsync(resourceGroupName, profileName, originGroupName).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes an existing origin group within a profile.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
     * within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String profileName, String originGroupName,
        Context context) {
        return beginDeleteAsync(resourceGroupName, profileName, originGroupName, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes an existing origin group within a profile.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
     * within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String profileName, String originGroupName) {
        deleteAsync(resourceGroupName, profileName, originGroupName).block();
    }

    /**
     * Deletes an existing origin group within a profile.
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
     * within the resource group.
     * @param originGroupName Name of the origin group which is unique within the profile.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String profileName, String originGroupName, Context context) {
        deleteAsync(resourceGroupName, profileName, originGroupName, context).block();
    }

    /**
     * Checks the quota and actual usage of endpoints under the given Azure Front Door profile..
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
     * within the resource group.
     * @param originGroupName Name of the origin group which is unique within the endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list usages operation response along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<UsageInner>> listResourceUsageSinglePageAsync(String resourceGroupName,
        String profileName, String originGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (originGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter originGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listResourceUsage(this.client.getEndpoint(), resourceGroupName, profileName,
                originGroupName, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .<PagedResponse<UsageInner>>map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(),
                res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Checks the quota and actual usage of endpoints under the given Azure Front Door profile..
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
     * within the resource group.
     * @param originGroupName Name of the origin group which is unique within the endpoint.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list usages operation response along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<UsageInner>> listResourceUsageSinglePageAsync(String resourceGroupName,
        String profileName, String originGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (originGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter originGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listResourceUsage(this.client.getEndpoint(), resourceGroupName, profileName, originGroupName,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Checks the quota and actual usage of endpoints under the given Azure Front Door profile..
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
     * within the resource group.
     * @param originGroupName Name of the origin group which is unique within the endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list usages operation response as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<UsageInner> listResourceUsageAsync(String resourceGroupName, String profileName,
        String originGroupName) {
        return new PagedFlux<>(() -> listResourceUsageSinglePageAsync(resourceGroupName, profileName, originGroupName),
            nextLink -> listResourceUsageNextSinglePageAsync(nextLink));
    }

    /**
     * Checks the quota and actual usage of endpoints under the given Azure Front Door profile..
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
     * within the resource group.
     * @param originGroupName Name of the origin group which is unique within the endpoint.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list usages operation response as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<UsageInner> listResourceUsageAsync(String resourceGroupName, String profileName,
        String originGroupName, Context context) {
        return new PagedFlux<>(
            () -> listResourceUsageSinglePageAsync(resourceGroupName, profileName, originGroupName, context),
            nextLink -> listResourceUsageNextSinglePageAsync(nextLink, context));
    }

    /**
     * Checks the quota and actual usage of endpoints under the given Azure Front Door profile..
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
     * within the resource group.
     * @param originGroupName Name of the origin group which is unique within the endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list usages operation response as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<UsageInner> listResourceUsage(String resourceGroupName, String profileName,
        String originGroupName) {
        return new PagedIterable<>(listResourceUsageAsync(resourceGroupName, profileName, originGroupName));
    }

    /**
     * Checks the quota and actual usage of endpoints under the given Azure Front Door profile..
     * 
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
     * within the resource group.
     * @param originGroupName Name of the origin group which is unique within the endpoint.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list usages operation response as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<UsageInner> listResourceUsage(String resourceGroupName, String profileName,
        String originGroupName, Context context) {
        return new PagedIterable<>(listResourceUsageAsync(resourceGroupName, profileName, originGroupName, context));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list origin groups along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<AfdOriginGroupInner>> listByProfileNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByProfileNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<AfdOriginGroupInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list origin groups along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<AfdOriginGroupInner>> listByProfileNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listByProfileNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list usages operation response along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<UsageInner>> listResourceUsageNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listResourceUsageNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<UsageInner>>map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(),
                res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list usages operation response along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<UsageInner>> listResourceUsageNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listResourceUsageNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
