// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.cdn.models.ProfileLogScrubbing;
import com.azure.resourcemanager.cdn.models.ProfileProvisioningState;
import com.azure.resourcemanager.cdn.models.ProfileResourceState;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/**
 * The JSON object that contains the properties required to create a profile.
 */
@Fluent
public final class ProfileProperties {
    /*
     * Resource status of the profile.
     */
    @JsonProperty(value = "resourceState", access = JsonProperty.Access.WRITE_ONLY)
    private ProfileResourceState resourceState;

    /*
     * Provisioning status of the profile.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ProfileProvisioningState provisioningState;

    /*
     * Key-Value pair representing additional properties for profiles.
     */
    @JsonProperty(value = "extendedProperties", access = JsonProperty.Access.WRITE_ONLY)
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, String> extendedProperties;

    /*
     * The Id of the frontdoor.
     */
    @JsonProperty(value = "frontDoorId", access = JsonProperty.Access.WRITE_ONLY)
    private String frontDoorId;

    /*
     * Send and receive timeout on forwarding request to the origin. When timeout is reached, the request fails and
     * returns.
     */
    @JsonProperty(value = "originResponseTimeoutSeconds")
    private Integer originResponseTimeoutSeconds;

    /*
     * Defines rules that scrub sensitive fields in the Azure Front Door profile logs.
     */
    @JsonProperty(value = "logScrubbing")
    private ProfileLogScrubbing logScrubbing;

    /**
     * Creates an instance of ProfileProperties class.
     */
    public ProfileProperties() {
    }

    /**
     * Get the resourceState property: Resource status of the profile.
     * 
     * @return the resourceState value.
     */
    public ProfileResourceState resourceState() {
        return this.resourceState;
    }

    /**
     * Get the provisioningState property: Provisioning status of the profile.
     * 
     * @return the provisioningState value.
     */
    public ProfileProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the extendedProperties property: Key-Value pair representing additional properties for profiles.
     * 
     * @return the extendedProperties value.
     */
    public Map<String, String> extendedProperties() {
        return this.extendedProperties;
    }

    /**
     * Get the frontDoorId property: The Id of the frontdoor.
     * 
     * @return the frontDoorId value.
     */
    public String frontDoorId() {
        return this.frontDoorId;
    }

    /**
     * Get the originResponseTimeoutSeconds property: Send and receive timeout on forwarding request to the origin.
     * When timeout is reached, the request fails and returns.
     * 
     * @return the originResponseTimeoutSeconds value.
     */
    public Integer originResponseTimeoutSeconds() {
        return this.originResponseTimeoutSeconds;
    }

    /**
     * Set the originResponseTimeoutSeconds property: Send and receive timeout on forwarding request to the origin.
     * When timeout is reached, the request fails and returns.
     * 
     * @param originResponseTimeoutSeconds the originResponseTimeoutSeconds value to set.
     * @return the ProfileProperties object itself.
     */
    public ProfileProperties withOriginResponseTimeoutSeconds(Integer originResponseTimeoutSeconds) {
        this.originResponseTimeoutSeconds = originResponseTimeoutSeconds;
        return this;
    }

    /**
     * Get the logScrubbing property: Defines rules that scrub sensitive fields in the Azure Front Door profile logs.
     * 
     * @return the logScrubbing value.
     */
    public ProfileLogScrubbing logScrubbing() {
        return this.logScrubbing;
    }

    /**
     * Set the logScrubbing property: Defines rules that scrub sensitive fields in the Azure Front Door profile logs.
     * 
     * @param logScrubbing the logScrubbing value to set.
     * @return the ProfileProperties object itself.
     */
    public ProfileProperties withLogScrubbing(ProfileLogScrubbing logScrubbing) {
        this.logScrubbing = logScrubbing;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (logScrubbing() != null) {
            logScrubbing().validate();
        }
    }
}
