// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Defines the parameters for RequestScheme match conditions.
 */
@Fluent
public final class RequestSchemeMatchConditionParameters {
    /*
     * The typeName property.
     */
    @JsonProperty(value = "typeName", required = true)
    private String typeName = "DeliveryRuleRequestSchemeConditionParameters";

    /*
     * Describes operator to be matched
     */
    @JsonProperty(value = "operator", required = true)
    private String operator = "Equal";

    /*
     * Describes if this is negate condition or not
     */
    @JsonProperty(value = "negateCondition")
    private Boolean negateCondition;

    /*
     * List of transforms
     */
    @JsonProperty(value = "transforms")
    private List<Transform> transforms;

    /*
     * The match value for the condition of the delivery rule
     */
    @JsonProperty(value = "matchValues")
    private List<RequestSchemeMatchConditionParametersMatchValuesItem> matchValues;

    /**
     * Creates an instance of RequestSchemeMatchConditionParameters class.
     */
    public RequestSchemeMatchConditionParameters() {
    }

    /**
     * Get the typeName property: The typeName property.
     * 
     * @return the typeName value.
     */
    public String typeName() {
        return this.typeName;
    }

    /**
     * Set the typeName property: The typeName property.
     * 
     * @param typeName the typeName value to set.
     * @return the RequestSchemeMatchConditionParameters object itself.
     */
    public RequestSchemeMatchConditionParameters withTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    /**
     * Get the operator property: Describes operator to be matched.
     * 
     * @return the operator value.
     */
    public String operator() {
        return this.operator;
    }

    /**
     * Set the operator property: Describes operator to be matched.
     * 
     * @param operator the operator value to set.
     * @return the RequestSchemeMatchConditionParameters object itself.
     */
    public RequestSchemeMatchConditionParameters withOperator(String operator) {
        this.operator = operator;
        return this;
    }

    /**
     * Get the negateCondition property: Describes if this is negate condition or not.
     * 
     * @return the negateCondition value.
     */
    public Boolean negateCondition() {
        return this.negateCondition;
    }

    /**
     * Set the negateCondition property: Describes if this is negate condition or not.
     * 
     * @param negateCondition the negateCondition value to set.
     * @return the RequestSchemeMatchConditionParameters object itself.
     */
    public RequestSchemeMatchConditionParameters withNegateCondition(Boolean negateCondition) {
        this.negateCondition = negateCondition;
        return this;
    }

    /**
     * Get the transforms property: List of transforms.
     * 
     * @return the transforms value.
     */
    public List<Transform> transforms() {
        return this.transforms;
    }

    /**
     * Set the transforms property: List of transforms.
     * 
     * @param transforms the transforms value to set.
     * @return the RequestSchemeMatchConditionParameters object itself.
     */
    public RequestSchemeMatchConditionParameters withTransforms(List<Transform> transforms) {
        this.transforms = transforms;
        return this;
    }

    /**
     * Get the matchValues property: The match value for the condition of the delivery rule.
     * 
     * @return the matchValues value.
     */
    public List<RequestSchemeMatchConditionParametersMatchValuesItem> matchValues() {
        return this.matchValues;
    }

    /**
     * Set the matchValues property: The match value for the condition of the delivery rule.
     * 
     * @param matchValues the matchValues value to set.
     * @return the RequestSchemeMatchConditionParameters object itself.
     */
    public RequestSchemeMatchConditionParameters
        withMatchValues(List<RequestSchemeMatchConditionParametersMatchValuesItem> matchValues) {
        this.matchValues = matchValues;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
