// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Defines the parameters for the origin group override action.
 */
@Fluent
public final class OriginGroupOverrideActionParameters {
    /*
     * The typeName property.
     */
    @JsonProperty(value = "typeName", required = true)
    private String typeName = "DeliveryRuleOriginGroupOverrideActionParameters";

    /*
     * defines the OriginGroup that would override the DefaultOriginGroup.
     */
    @JsonProperty(value = "originGroup", required = true)
    private ResourceReference originGroup;

    /**
     * Creates an instance of OriginGroupOverrideActionParameters class.
     */
    public OriginGroupOverrideActionParameters() {
    }

    /**
     * Get the typeName property: The typeName property.
     * 
     * @return the typeName value.
     */
    public String typeName() {
        return this.typeName;
    }

    /**
     * Set the typeName property: The typeName property.
     * 
     * @param typeName the typeName value to set.
     * @return the OriginGroupOverrideActionParameters object itself.
     */
    public OriginGroupOverrideActionParameters withTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    /**
     * Get the originGroup property: defines the OriginGroup that would override the DefaultOriginGroup.
     * 
     * @return the originGroup value.
     */
    public ResourceReference originGroup() {
        return this.originGroup;
    }

    /**
     * Set the originGroup property: defines the OriginGroup that would override the DefaultOriginGroup.
     * 
     * @param originGroup the originGroup value to set.
     * @return the OriginGroupOverrideActionParameters object itself.
     */
    public OriginGroupOverrideActionParameters withOriginGroup(ResourceReference originGroup) {
        this.originGroup = originGroup;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (originGroup() == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                "Missing required property originGroup in model OriginGroupOverrideActionParameters"));
        } else {
            originGroup().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(OriginGroupOverrideActionParameters.class);
}
