// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Web Application Firewall Mapping.
 */
@Fluent
public final class MigrationWebApplicationFirewallMapping {
    /*
     * Migration From Waf policy
     */
    @JsonProperty(value = "migratedFrom")
    private ResourceReference migratedFrom;

    /*
     * Migration to Waf policy
     */
    @JsonProperty(value = "migratedTo")
    private ResourceReference migratedTo;

    /**
     * Creates an instance of MigrationWebApplicationFirewallMapping class.
     */
    public MigrationWebApplicationFirewallMapping() {
    }

    /**
     * Get the migratedFrom property: Migration From Waf policy.
     * 
     * @return the migratedFrom value.
     */
    public ResourceReference migratedFrom() {
        return this.migratedFrom;
    }

    /**
     * Set the migratedFrom property: Migration From Waf policy.
     * 
     * @param migratedFrom the migratedFrom value to set.
     * @return the MigrationWebApplicationFirewallMapping object itself.
     */
    public MigrationWebApplicationFirewallMapping withMigratedFrom(ResourceReference migratedFrom) {
        this.migratedFrom = migratedFrom;
        return this;
    }

    /**
     * Get the migratedTo property: Migration to Waf policy.
     * 
     * @return the migratedTo value.
     */
    public ResourceReference migratedTo() {
        return this.migratedTo;
    }

    /**
     * Set the migratedTo property: Migration to Waf policy.
     * 
     * @param migratedTo the migratedTo value to set.
     * @return the MigrationWebApplicationFirewallMapping object itself.
     */
    public MigrationWebApplicationFirewallMapping withMigratedTo(ResourceReference migratedTo) {
        this.migratedTo = migratedTo;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (migratedFrom() != null) {
            migratedFrom().validate();
        }
        if (migratedTo() != null) {
            migratedTo().validate();
        }
    }
}
